/*
 * character OLED module (SO1602AWWB/SO1602AWYB/SO2002AWWB-UA-WB-U)
 *   http://blog.digit-parts.com/archives/51724945.html
 *
 * I2C LCD adapter
 *   http://mbed.org/users/okini3939/notebook/i2c-lcd-library/
 */

#include "mbed.h"

#define I2CLCD_ADDR 0x7c

DigitalOut myled(LED1);
I2C i2c(p9, p10);

void lcd_out (char dat, char rs) {
    i2c.start();
    i2c.write(I2CLCD_ADDR);
    i2c.write(rs ? 0x40 : 0);
    i2c.write(dat);
    i2c.stop();
}

int main() {

    myled = 1;
    wait_ms(100);
    myled = 0;
/*
    lcd_out(0x30, 0);
    wait_ms(5);
    lcd_out(0x30, 0);
    wait_ms(2);
    lcd_out(0x30, 0);

    lcd_out(0x38, 0); // func 
    lcd_out(0x10, 0); // shift
    lcd_out(0x0c, 0); // display
    lcd_out(0x06, 0); // entry mode
*/
    lcd_out(0x01, 0); // clear
    wait_ms(2);
    lcd_out(0x02, 0); // home
    wait_ms(2);
    lcd_out(0x0f, 0); // display

    lcd_out(0x2a, 0); // FunctionSet RE=1, IS=0
    lcd_out(0x79, 0); // OLEDCharacterization SD=1
    lcd_out(0x81, 0); // Set Contrast Control 
    lcd_out(0x10, 0); // Contrast
    lcd_out(0x78, 0); // OLEDCharacterization SD=0
    lcd_out(0x28, 0); // FunctionSet RE=0, IS=0

    for (int i = 0; i < 16; i ++) {
        lcd_out('A' + i, 1);
    }

    wait(1);
    lcd_out(0x2c, 0);
    wait(1);

//    lcd_out(0x80 + 20, 0);
    lcd_out(0x01, 0); // clear
    wait_ms(2);

    lcd_out(0xc3, 1);
    lcd_out(0xde, 1);
    lcd_out(0xbc, 1);
    lcd_out(0xde, 1);
    lcd_out(0xaf, 1);
    lcd_out(0xc4, 1);

    lcd_out(' ', 1);
    lcd_out('O', 1);
    lcd_out('L', 1);
    lcd_out('E', 1);
    lcd_out('D', 1);
    lcd_out(' ', 1);

    lcd_out(0xbd, 1);
    lcd_out(0xb6, 1);
    lcd_out(0xde, 1);
    lcd_out(0xb0, 1);
/*
    lcd_out(0xba, 1);
    lcd_out(0xb2, 1);
    lcd_out(0xce, 1);
    lcd_out(0xde, 1);
    lcd_out(0xb2, 1);
*/

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
