/*
 * mbed library for I2C LED Display
 * Copyright (c) 2010 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * This product includes:
 * mbed TextLCD Library, for a 4-bit LCD based on HD44780
 * Copyright (c) 2007-2010, sford
 */
 
#ifndef I2CLEDDisp_H
#define I2CLEDDisp_H

#include "mbed.h"

#define I2CLEDDisp_ADDR 0x78

enum I2CLEDDispType {
    LEDDISP4x1		= 1,
    LEDDISP4x1x2	= 2,
    LEDDISP4x1x3	= 3,
    LEDDISP4x1x4	= 4
};

enum I2CLEDDispConfig {
    LEDDISPCFG_ENABLE   = 0x80,
    LEDDISPCFG_SPEED    = 0x40,
    LEDDISPCFG_ADDR1    = 0x20,
    LEDDISPCFG_ADDR0    = 0x10,
    LEDDISPCFG_INIT     = 0x08
};

enum I2CLEDDispControl {
	LEDDISP_CONTROL_B0      = 0x00,
	LEDDISP_CONTROL_B25     = 0x01,
	LEDDISP_CONTROL_B50     = 0x02,
	LEDDISP_CONTROL_B100    = 0x03,
	LEDDISP_CONTROL_AC	    = 0x00,
	LEDDISP_CONTROL_AB	    = 0x04,
	LEDDISP_CONTROL_ABC	    = 0x08,
	LEDDISP_CONTROL_ACC     = 0x0c,
	LEDDISP_CONTROL_ATTRIB  = 0x10,
	LEDDISP_CONTROL_BLINK	= 0x20,
	LEDDISP_CONTROL_TEST	= 0x40,
	LEDDISP_CONTROL_CLEAR	= 0x80
};

class I2CLEDDisp : public Stream {
public:
    I2CLEDDisp (PinName p_sda, PinName p_scl, int p_i2caddr = I2CLEDDisp_ADDR, I2CLEDDispType p_type = LEDDISP4x1, I2CLEDDispControl p_ctrl = LEDDISP_CONTROL_B100);
    I2CLEDDisp (I2C& p_i2c, int p_i2caddr = I2CLEDDisp_ADDR, I2CLEDDispType p_type = LEDDISP4x1, I2CLEDDispControl p_ctrl = LEDDISP_CONTROL_B100);

    void locate (int, int);
    void cls ();
    void disp_cfg (I2CLEDDispConfig);

protected:
    virtual int _putc (int);
    virtual int _getc ();

    int address (int, int);
    int rows ();
    int cols ();
    void init (int, I2CLEDDispType, I2CLEDDispControl);
    void disp_out (int, int);
    int disp_in (int);

    I2C i2c;
    int i2caddr, addr;
    I2CLEDDispType type;
    I2CLEDDispControl ctrl;
    int x, y;
};

#endif
