/*
 * mbed library for I2C LED Display
 * Copyright (c) 2010 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * This product includes:
 * mbed TextLCD Library, for a 4-bit LCD based on HD44780
 * Copyright (c) 2007-2010, sford
 */

#include "mbed.h"
#include "I2CLEDDisp.h"


int I2CLEDDisp::_putc (int value) {

    if (value == '\n') {
		locate(0, 0);

    } else {

        disp_out(value, address(x, y));
        x ++;
        if (x >= cols()) {
            x = 0;
        }

		if (ctrl & LEDDISP_CONTROL_ATTRIB && (ctrl & 0x03) != LEDDISP_CONTROL_AB) {
	        disp_out(0x80 | disp_in(address(x, y)), address(x, y));
		}

    }

    return value;
}

int I2CLEDDisp::_getc() {
	int i;

	i = disp_in(x);
    x ++;
    if (x >= cols()) {
        x = 0;
    }
    return i;
}


I2CLEDDisp::I2CLEDDisp (PinName p_sda, PinName p_scl, int p_i2caddr, I2CLEDDispType p_type, I2CLEDDispControl p_ctrl) : i2c(p_sda, p_scl) {
    init(p_i2caddr, p_type, p_ctrl);
}

I2CLEDDisp::I2CLEDDisp (I2C& p_i2c, int p_i2caddr, I2CLEDDispType p_type, I2CLEDDispControl p_ctrl) : i2c(p_i2c) {
    init(p_i2caddr, p_type, p_ctrl);
}

void I2CLEDDisp::init (int p_i2caddr, I2CLEDDispType p_type, I2CLEDDispControl p_ctrl) {

	i2caddr = p_i2caddr;
    type = p_type;
    ctrl = p_ctrl;

    cls();
}

void I2CLEDDisp::cls() {
	int i;
	
	for (i = 0; i < type; i ++) {
	    disp_out(LEDDISP_CONTROL_CLEAR, i << 4);
	    disp_out(ctrl, i << 4);
	}
    locate(0, 0);
}

void I2CLEDDisp::locate(int col, int row) {
	if (ctrl & LEDDISP_CONTROL_ATTRIB && (ctrl & 0x03) != LEDDISP_CONTROL_AB) {
        disp_out(~0x80 & disp_in(address(x, y)), address(x, y));
	    x = col;
	    y = row;
        disp_out(0x80 | disp_in(address(x, y)), address(x, y));
	} else {
	    x = col;
	    y = row;
	}
}

int I2CLEDDisp::address(int col, int row) {
	return ((col & 0x0c) << 2) | 0x04 | (~col & 0x03);
}

int I2CLEDDisp::cols() {
	return 4 * type;
}

int I2CLEDDisp::rows() {
	return 1;
}

void I2CLEDDisp::disp_cfg (I2CLEDDispConfig cfg) {
	int i;
	
	for (i = 0; i < type; i ++) {
    	i2c.start();
    	i2c.write(i2caddr + (i << 1));
    	i2c.write(LEDDISPCFG_ENABLE | (cfg & 0x71));
    	i2c.stop();
	}
}

void I2CLEDDisp::disp_out (int dat, int addr) {
    i2c.start();
    i2c.write(i2caddr | (addr >> 3));
    i2c.write(addr & 0x07);
    i2c.write(dat);
    i2c.stop();
}

int I2CLEDDisp::disp_in (int rs) {
    int i;

    i2c.start();
    i2c.write(i2caddr | (addr >> 3));
    i2c.write(addr & 0x07);

    i2c.start();
    i2c.write(i2caddr | (addr >> 3) | 0x01);
    i = i2c.read(0);
    i2c.stop();

    return i;
}

