#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "mbed_rpc.h"
#include "HTTPD.h"

EthernetInterface *eth;
HTTPD *httpd;

Serial pc(USBTX, USBRX);
LocalFileSystem local("local");
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

void callback_cgi (int id) {
    int i, n;
    char buf[256];

    strcpy(buf, httpd->getFilename(id));
    strcat(buf, "\r\n");
    strcat(buf, httpd->getQueryString(id));
    strcat(buf, "\r\n");
    n = strlen(buf);

    i = httpd->receive(id, &buf[n], sizeof(buf) - n);
    if (i < 0) return;
    i += n;
    buf[i] = 0;

    printf("CGI %d %s\r\n", id, buf);
    httpd->send(id, buf, i, "Content-Type: text/plain\r\n");
}

void callback_ws (int id) {
    int i;
    char buf[256];

    i = httpd->receive(id, buf, sizeof(buf));
    if (i < 0) return;
    buf[i] = 0;

    printf("WS %d %s\r\n", id, buf);
    httpd->sendWebsocket(id, buf, i);
}

void callback_rpc (int id) {
    char buf[40], outbuf[40];

    strcpy(buf, "/");
    httpd->urldecode(httpd->getFilename(id), &buf[1], sizeof(buf) - 2);
    RPC::call(buf, outbuf);

    printf("RPC id %d '%s' '%s'\r\n", id, buf, outbuf);
    httpd->send(id, outbuf, strlen(outbuf), "Content-Type: text/plain\r\n");
}

int main () {

    pc.baud(115200);
    printf("HTTP Server...\r\n");

    eth = new EthernetInterface;
//    eth->init(); //Use DHCP
    eth->init("192.168.1.2", "255.255.255.0", "192.168.1.1");
    if (eth->connect()) return -1;
    printf("IP Address is %s\r\n", eth->getIPAddress());

//    RPC::add_rpc_class<RpcAnalogIn>();
//    RPC::add_rpc_class<RpcAnalogOut>();
    RPC::add_rpc_class<RpcDigitalIn>();
    RPC::add_rpc_class<RpcDigitalOut>();
    RPC::add_rpc_class<RpcDigitalInOut>();
    RPC::add_rpc_class<RpcPwmOut>();

    httpd = new HTTPD;
    httpd->attach("/cgi-bin/", &callback_cgi);
    httpd->attach("/ws/", &callback_ws);
    httpd->attach("/rpc/", &callback_rpc);
    httpd->attach("/", "/local/");
    httpd->start(80);
    printf("httpd ready\r\n");
    led1 = 1;

    for (;;) {
    }
}
