
#if defined(TARGET_LPC11U24)
#define DBG(...) printf("dbg: " __VA_ARGS__)
#define FLASH_SECTOR 7
#define MAX_SECTOR 1
#elif defined(TARGET_LPC11U35_401)
#define DBG(...)
#define FLASH_SECTOR 8
#define MAX_SECTOR 8
#endif

struct FatInfo {
    uint8_t Name[11];
    uint8_t Attr;
    uint8_t NTRes;
    uint8_t CrtTimeTenth;
    uint16_t CrtTime;
    uint16_t CrtDate;
    uint16_t LstAccDate;
    uint16_t FstClusHI;
    uint16_t WrtTime;
    uint16_t WrtDate;
    uint16_t FstClusLO;
    uint32_t FileSize;
} __attribute__((packed));

struct BmpHeader {
    uint8_t  magic[2];                  // Magic identifier
    uint32_t size;                      // File size in bytes
    uint16_t reserved1;     // Not used
    uint16_t reserved2;       // Not used
    uint32_t offset;                    // Offset to image data in bytes
    uint32_t header_size;               // Header size in bytes
    int32_t  width;                     // Width of the image
    int32_t  height;                    // Height of image
    uint16_t planes;                    // Number of color planes
    uint16_t bits;                      // Bits per pixel
    uint32_t compression;               // Compression type
    uint32_t imagesize;                 // Image size in bytes
    int32_t  xresolution;               // Pixels per meter
    int32_t  yresolution;               // Pixels per meter
    uint32_t ncolours;                  // Number of colors  
    uint32_t importantcolours;          // Important colors
    uint8_t  data[];
} __attribute__((packed));


void workMsd ();

char *getPicture (int n);


