#include "mbed.h"
#include "USBMSD_Ram.h"
#include "IAP.h"
#include "file.h"

//USBMSD_Ram msd;
IAP iap;
extern DigitalOut led;

int parseSector = 0;
int modeBmp = 0;
int filesize;
int count = 0;
int sector = 0;

int parseBmp (const uint8_t *buf, int len) {
    int i, n = 0;

    if (modeBmp == 0) {
        struct BmpHeader *header = (struct BmpHeader *)buf;
        if (header->magic[0] != 'B' || header->magic[1] != 'M') return -1;
        filesize = header->size;
        if (header->header_size != 40) return -1;
        DBG(" %d %d %d %d\r\n", filesize, header->width, header->height, header->bits);
        if (header->compression != 0 || header->ncolours != 0) return -1;
        if (header->size >= 4096 || header->bits != 24) return -1;

        __disable_irq();
        iap.prepare(FLASH_SECTOR + sector, FLASH_SECTOR + sector);
        iap.erase(FLASH_SECTOR + sector, FLASH_SECTOR + sector);
        __enable_irq();
        count = 0;
        modeBmp = 1;
    }
    
    if (modeBmp) {
        led = 0;
        __disable_irq();
        iap.prepare(FLASH_SECTOR + sector, FLASH_SECTOR + sector);
        iap.write((char*)buf, sector_start_adress[FLASH_SECTOR + sector] + 512 * count, len);
        __enable_irq();
        count += len / 512;
        filesize -= len;

        if (filesize <= 0 || count >= (FLASH_SECTOR_SIZE / 512)) {
            modeBmp = 0;
            led = 1;
            sector ++;
            if (sector >= MAX_SECTOR) {
                sector = 0;
            }
            return -1;
        }
    }
    return 0;
}

void parseFat(int sector, const uint8_t *buf, int len) {
    int i;

    if (sector == 2) {
        // root dir
        struct FatInfo *fat = (struct FatInfo *)buf;
        parseSector = 0;
        for (i = 0; i < 16; i ++) {
            if (fat[i].Name[0] == 0) break;
            if (fat[i].Name[0] != 0xe5 && fat[i].Name[8] == 'B' && fat[i].Name[9] == 'M' && fat[i].Name[10] == 'P') {
                parseSector = (fat[i].FstClusHI<<16) || fat[i].FstClusLO;
                break;
            }
        }
    } else
    if (sector > 2) {
        // data
        if (parseSector && sector >= parseSector) {
            if (parseBmp(buf, len)) {
                parseSector = 0;
            }
        } else {
            parseSector = 0;
        }
    }
}

char *getPicture (int n) {
    char *p = sector_start_adress[FLASH_SECTOR + n];
    if (p[0] == 'B' && p[1] == 'M') {
        return p;
    }
    return NULL;
}

void workMsd () {
    USBMSD_Ram msd;

    msd.parseFat = &parseFat;

    for (;;) {
        led = 1;
        wait(1);
    }
}
