/*
 * Suga-koubou Graphic Poi Kit
 *   LPC11U35 (select EA LPC11U35 QuickStart Board)
 *   APA102 (Adafruit DotStar LED Strip)
 */
#include "mbed.h"
#include "file.h"

#define LED_NUM     32
#define LED_GLOBAL  31 // brightness 0-31
#define LED_FREQ    500000 // spi
#define LED_WAIT    1 // *10ms

#if defined(TARGET_LPC11U24)
Serial pc(USBTX, USBRX);
DigitalIn usb_vbus(p30);
#else
DigitalIn usb_vbus(P0_3);
#endif
DigitalOut led(LED1);
DigitalIn button(P0_1);
SPI spi(P0_21, P0_22, P1_15);

void dotStar (int *buf, int num) {
    int i;

    // start frame
    for (i = 0; i < 4; i ++) {
        spi.write(0);
    }
    // led frame
    for (i = 0; i < num; i ++) {
        spi.write((7<<5) | LED_GLOBAL);
        spi.write((buf[i] >> 16) & 0xff); // B
        spi.write((buf[i] >> 8) & 0xff); // G
        spi.write(buf[i] & 0xff); // R
    }
    // end frame
    for (i = 0; i < 4; i ++) {
        spi.write(1);
    }
}

void dotStar_off () {
    int i;

    for (i = 0; i < 4; i ++) {
        spi.write(0);
    }
    for (i = 0; i < LED_NUM; i ++) {
        spi.write((7<<5) | LED_GLOBAL);
        spi.write(0);
        spi.write(0);
        spi.write(0);
    }
    for (i = 0; i < 4; i ++) {
        spi.write(1);
    }
}

void work () {
    int i, a, x, y;
    int led_buf[LED_NUM];
    int num = 0;
    char *buf = getPicture(num);
    struct BmpHeader *header = (struct BmpHeader *)buf;

    if (buf == NULL) return;
    DBG(" %d: %08x\r\n", num, buf);
    y = 0;
    a = 0;
    for (;;) {
        for (x = 0; x < header->width; x ++) {
          if (x < LED_NUM) {
            led_buf[x] = (header->data[a] << 16) | (header->data[a + 1] << 8) | header->data[a + 2];
          }
          a += 3;
        }
        for (; x < LED_NUM; x ++) {
            led_buf[x] = 0;
        }
        a = ((a + 3) / 4) * 4; // padding
        DBG("%d %d %d/%d\r\n", a, y, header->width, header->height);
        dotStar(led_buf, LED_NUM);
        y ++;
        if (y >= header->height) {
            y = 0;
            a = 0;
            led = 0;
        }

        for (i = 0; i < LED_WAIT; i ++) {
            if (button == 0) {
                led = 1;
next:
                num ++;
                if (num >= MAX_SECTOR) {
                    num = 0;
                }
                buf = getPicture(num);
                if (buf == NULL) goto next;
                header = (struct BmpHeader *)buf;
                DBG(" %d: %08x\r\n", num, buf);
                while (button == 0);
            }
            wait_ms(1);
        }
    }
}

void demo () {
    int i, c;
    int color = 7;
    int led_buf[LED_NUM];

    for (;;) {
        for (i = 0; i < LED_NUM; i ++) {
            c = ((i + color) % 7) + 1;
            led_buf[i] = (c & 4 ? 0xff0000 : 0) | (c & 2 ? 0xff00 : 0) | (c & 1 ? 0xff : 0);
        }
        dotStar(led_buf, LED_NUM);
        led = !led;

        wait_ms(500);
        color --;
        if (color <= 0) color = 7;
    }
}

int main() {

    LPC_SYSCON->BODCTRL = 0x12; // BOD Reset 2.4V

    button.mode(PullUp);
    usb_vbus.mode(PullDown);
#if defined(TARGET_LPC11U24)
    pc.baud(115200);
#endif
    DBG("*** MSD\r\n");

    wait_ms(10);
    spi.frequency(LED_FREQ);
    dotStar_off();

    if (usb_vbus) {
        DBG("usb\r\n");
        workMsd();
    }

    DBG("work\r\n");
    work();

    // demo
    DBG("demo\r\n");
    demo();
}

extern "C" void HardFault_Handler() {
    for (;;) {
        led = !led;
        for (volatile int w = 0; w < 1000000; w ++);
    }
}
