#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
 
#define API_KEY "XXXXXXXX"
#define FEED_ID "0000"
#define GEIGER_PIN p10

EthernetNetIf eth;
InterruptIn intcounter(GEIGER_PIN);
volatile int count;
 
void interrupt_counter () {
    count ++;
}

int get_counter () {
    int c;
    c = count;
    count = 0;
    return c;
}

void init_counter () {
    count = 0;
    intcounter.fall(&interrupt_counter);
}

void pachube (char *csv) {
    char uri[100];
    HTTPResult ret;
    HTTPText csvContent("text/csv");
    HTTPClient clientP;
 
    clientP.setRequestHeader("X-PachubeApiKey", API_KEY);
    csvContent.set(csv);
    strcpy(uri, "http://api.pachube.com/v1/feeds/");
    strcat(uri, FEED_ID);
    strcat(uri, ".csv?_method=put");
    ret = clientP.post(uri, csvContent, NULL);

    if (ret != HTTP_OK && ret != HTTP_PROCESSING) {
        // error
    }
}

int main() {
    Timer timer;
    int i;
    char buf[10];

    eth.setup();
    init_counter();
    
    timer.start();
    while (1) {
        i = get_counter();
        sprintf(buf, "%d", i);
        pachube(buf);

        while (timer.read() < 60) wait(1);
        timer.reset();
    }
}
