#include "mbed.h"
#include "7seg.h"

#define LED_NUM 6
#define DIGITS_NUM 37

const int digits[DIGITS_NUM] = {0x3f, 0x06, 0x5b, 0x4f, 0x66, 0x6d, 0x7d, 0x07, 0x7f, 0x6f, // 0-9
                                0x77, 0x7c, 0x58, 0x5e, 0x79, 0x71, 0x3d, 0x74, 0x04, 0x1e, // a-j
                                0x76, 0x38, 0x54, 0x54, 0x5c, 0x73, 0x67, 0x50, 0x6d, 0x78, // k-t
                                0x1c, 0x1c, 0x1c, 0x76, 0x6e, 0x5b, 0x40}; // u-z,-

static DigitalOut led_k[8] = {p34, p36, p26, p24, p23, p35, p30, p25};
static DigitalOut led_a[LED_NUM] = {p16, p17, p18, p19, p15, p14};
static Ticker tick;

static int ledbuf[LED_NUM];

void leddisp () {
    static int n = 0;
    int i, bit;
    
    // led off
    for (i = 0; i < 8; i ++) {
        led_k[i] = 1;
    }
    led_a[n] = 1; // common off

    n ++;
    if (n >= LED_NUM) n = 0;

    // led on
    bit = 1;
    for (i = 0; i < 8; i ++) {
        led_k[i] = ledbuf[n] & bit ? 0 : 1;
        bit = bit << 1;
    }
    led_a[n] = 0; // common on
}

void writeled (int num, int dot, int mask, int zero) {
    if (((num >= 1000) || (zero & 0x08)) && (mask & 0x08)) {
        ledbuf[0] = digits[num / 1000 % 10];
    } else {
        ledbuf[0] = 0;
    }
    if (((num >= 100) || (zero & 0x04)) && (mask & 0x04)) {
        ledbuf[1] = digits[(num / 100) % 10];
    } else {
        ledbuf[1] = 0;
    }
    if (((num >= 10) || (zero & 0x02)) && (mask & 0x02)) {
        ledbuf[2] = digits[(num / 10) % 10];
    } else {
        ledbuf[2] = 0;
    }
    if (mask & 0x01) {
        ledbuf[3] = digits[num % 10];
    } else {
        ledbuf[3] = 0;
    }

    if (dot >= 1 && dot <= 4) {
        ledbuf[dot - 1] |= 0x80;
    }
}

void writeled5 (int n, int d, int f) {
    if (f) {
        ledbuf[n] = digits[d];
    } else {
        ledbuf[n] = d;
    }
}

void initled () {
    int i;
    
    for (i = 0; i < LED_NUM; i ++) {
        led_a[i] = 1;
        ledbuf[i] = 0;
    }
    for (i = 0; i < 8; i ++) {
        led_k[i] = 1;
    }
}

void startled () {
    tick.attach_us(&leddisp, 2500); // 400Hz
}
