#include "mbed.h"
#include "GSwifi.h"

#define SECURITY GSSEC_WPA_PSK
#define SSID "WIFISSID"
#define PASSPHRASE "TESTPASS"


Serial pc(USBTX, USBRX);
DigitalOut myled(LED1);

GSwifi gs(p13, p14, p12, P0_22); // TX, RX, CTS, RTS


int main() {
    Host host;
    int sk;

    pc.baud(115200);
    pc.printf("Gainspan\r\n");

    if (gs.connect(SECURITY, SSID, PASSPHRASE)) {
        pc.printf("Can't connected.\r\n");
        return -1;
    }
//    if (gs.setAddress(IpAddr(192,168,1,123), IpAddr(255,255,255,0), IpAddr(192,168,1,1), IpAddr(192,168,1,1))) {
    if (gs.setAddress()) {
        pc.printf("error: dhcp\r\n");
        return -1;
    }

    host.setName("mbed.org");
    host.setPort(80);
    if (! gs.getHostByName(host)) {
        pc.printf("resolv %d.%d.%d.%d\r\n", host.getIp()[0], host.getIp()[1], host.getIp()[2], host.getIp()[3]);

        sk = gs.open(host, GSPROT_TCP);
        if (sk >= 0) {
            int i;
            char buf[1500];

            gs.send(sk, "GET / HTTP/1.0", 18);
            gs.send(sk, "\r\n", 2);
            gs.send(sk, "\r\n", 2);
            wait_ms(1000);

            i = gs.recv(sk, buf, sizeof(buf));
            if (i) {
                buf[i] = 0;
                pc.printf("\r\n");
                pc.printf(buf);
            }

            gs.close(sk);
        }
    }

    myled = 1;
    for (;;) {
        if (pc.readable()) gs.putc(pc.getc());
        if (gs.readable()) pc.putc(gs.getc());
    }
}
