#include "mbed.h"
#include "GSwifi.h"

//#define USE_SLEEP
#define USE_STANDBY

#if defined(TARGET_LPC11U24)
Serial pc(USBTX, USBRX);
#endif
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
//InterruptIn sw1(p23), sw2(p24), sw3(p25), sw4(p26);
DigitalIn sw1(p23), sw2(p24), sw3(p25), sw4(p26);

#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
GSwifi gs(p13, p14, p12, P0_22); // TX, RX, CTS, RTS
DigitalOut gs_reset(p9), gs_wakeup(p10);
#elif defined(TARGET_LPC11U24)
GSwifi gs(p9, p10, p21, p22); // TX, RX, CTS, RTS
DigitalOut gs_reset(p27), gs_wakeup(p28);
#endif

Host server;
volatile int gsconnect = 0, button = 0;

void isr_sw1 () {
    if (gsconnect == 0) gsconnect = 1;
}

void isr_sw2 () {
    button = 1;
}

void isr_sw3 () {
    button = 2;
}

void isr_sw4 () {
    button = 3;
}

void isr_udp (int cid, int acid, int len) {
    int i;
    char buf[20];
    Host host;

    i = gs.recv(cid, buf, sizeof(buf), host);
    buf[i] = 0;
    if (i > 0 && strncmp("Welcome", buf, 7) == 0) {
        server.setIp(host.getIp());
    }
}

void find () {
    int i;
    int cid;
    Host bloadcast;
    
    bloadcast.setPort(10123);
    bloadcast.setIp(IpAddr(255,255,255,255));

    cid = gs.open(bloadcast, GSPROT_UDP, &isr_udp);
    if (cid >= 0) {
        gs.send(cid, "Hello", 5);
        for (i = 0; i < 15; i ++) {
            gs.poll();
            wait_ms(100);
        }
        gs.close(cid);
    }
}

void key () {
    if (sw1 == 0 && gsconnect == 0) gsconnect = 1;
    if (sw2 == 0 && button == 0) button = 1;
    if (sw3 == 0 && button == 0) button = 2;
    if (sw4 == 0 && button == 0) button = 3;
}

int main() {
    int i;

#if defined(TARGET_LPC11U24)
    pc.baud(115200);
#endif
    gs_reset = 0;
    gs_wakeup = 1;
    sw1.mode(PullUp);
    sw2.mode(PullUp);
    sw3.mode(PullUp);
    sw4.mode(PullUp);
    wait_ms(100);
/*
    sw1.fall(&isr_sw1);
    sw2.fall(&isr_sw2);
    sw3.fall(&isr_sw3);
    sw4.fall(&isr_sw4);
*/
    server.setPort(10123);
    server.setIp(IpAddr(192,168,111,20));
    gs_reset = 1;
    wait_ms(500);
    led1 = 1;

    for (;;) {
        key();
        gs.poll();
/*
        switch (gs.getStatus()) {
        case GSSTAT_READY:
            sleep();
            break;
        case GSSTAT_WAKEUP:
            gs.standby(600000);
            break;
        }
*/
        if (gs.getStatus() == GSSTAT_WAKEUP) {
            gs.standby(600000);
        }

        if (gsconnect == 1) {
            // WPS
            led1 = 0;
            led3 = 1;
            if (gs.connect(GSSEC_WPS_BUTTON, NULL, NULL, 1)) {
//            if (gs.connect(GSSEC_WPA2_PSK, "GSTEST", "testpass12345", 1)) {
                led1 = 1;
                led2 = 0;
                gsconnect = 0;
            } else {
                led1 = 0;
                led2 = 1;
                gsconnect = 2;
                
                find();
#ifdef USE_SLEEP
                gs.deepSleep();
#endif
#ifdef USE_STANDBY
                gs.standby(600000);
#endif
            }
            led3 = 0;
        }

        if (button) {
            led4 = 1;
            if (gsconnect == 2) {
                int cid;
                char buf[10];

#ifdef USE_SLEEP
                gs.wakeup();
#endif
#ifdef USE_STANDBY
                gs_wakeup = 0;
                while (gs.getStatus() != GSSTAT_WAKEUP) {
                    gs.poll();
                }
                gs_wakeup = 1;
                gs.wakeup();
#endif
                led3 = 1;
                cid = gs.open(server, GSPROT_UDP);
                if (cid >= 0) {
                    buf[0] = '0' + button;
                    gs.send(cid, buf, 1);
                    gs.close(cid);
                }
                led3 = 0;
#ifdef USE_SLEEP
                gs.deepSleep();
#endif
#ifdef USE_STANDBY
                gs.standby(600000);
#endif
            }
            button = 0;
            led4 = 0;
        }
        
    }
}
