#include "mbed.h"
#include "7seg.h"

static DigitalOut led_k[8] = {p34, p36, p26, p24, p23, p35, p30, p25};
static DigitalOut led_a[4] = {p16, p17, p18, p19};
static Ticker tick;

static int ledbuf[4] = {-1, -1, -1, -1};
const int digits[10] = {0x3f, 0x06, 0x5b, 0x4f, 0x66, 0x6d, 0x7d, 0x07, 0x7f, 0x6f};

void leddisp () {
    static int n = 0;
    int i, bit;
    
    // led off
    for (i = 0; i < 8; i ++) {
        led_k[i] = 1;
    }
    led_a[n] = 1; // common off

    n ++;
    if (n >= 4) n = 0;

    // led on
    if (ledbuf[n] >= 0) {
        bit = 1;
        for (i = 0; i < 7; i ++) {
            led_k[i] = digits[ledbuf[n] & 0x7f] & bit ? 0 : 1;
            bit = bit << 1;
        }
        led_k[7] = ledbuf[n] & 0x80 ? 0 : 1;
    }
    led_a[n] = 0; // common on
}

void writeled (int num, int dot, int mask, int zero) {
    if (((num >= 1000) || (zero & 0x08)) && (mask & 0x08)) {
        ledbuf[0] = num / 1000 % 10;
    } else {
        ledbuf[0] = -1;
    }
    if (((num >= 100) || (zero & 0x04)) && (mask & 0x04)) {
        ledbuf[1] = (num / 100) % 10;
    } else {
        ledbuf[1] = -1;
    }
    if (((num >= 10) || (zero & 0x02)) && (mask & 0x02)) {
        ledbuf[2] = (num / 10) % 10;
    } else {
        ledbuf[2] = -1;
    }
    if (mask & 0x01) {
        ledbuf[3] = num % 10;
    } else {
        ledbuf[3] = -1;
    }

    if (dot >= 1 && dot <= 4) {
        ledbuf[dot - 1] |= 0x80;
    }
}

void initled () {
    int i;
    
    for (i = 0; i < 4; i ++) {
        led_a[i] = 1;
    }
    for (i = 0; i < 8; i ++) {
        led_k[i] = 1;
    }
}

void startled () {
    tick.attach_us(&leddisp, 2500); // 400Hz
}
