#include "mbed.h"
#include "GSwifi.h"
#include "7seg.h"

#define HTTP_HOST "www.kepco.co.jp"
#define HTTP_URI "/yamasou/juyo1_kansai.csv"
#define SSID "ssid"
#define PASS "password"
#define NTP_HOST "ntp1.sakura.ad.jp"

#define VREF 3.3
#define B 3435 // thermistor B
#define T0 25.0
#define R0 10000.0 // R0 ohm
#define RU 10000.0 // pullup ohm

#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
Serial pc(USBTX, USBRX);
GSwifi gs(p13, p14, p12, P0_22); // TX, RX, CTS, RTS
DigitalOut gs_reset(p9), gs_wakeup(p10);
DigitalOut led1(LED1);
PwmOut led2(LED2), led3(LED3), led4(LED4);
#elif defined(TARGET_LPC11U24)
GSwifi gs(p9, p10, p21, p22); // TX, RX, CTS, RTS
//DigitalOut gs_reset(P1_14), gs_wakeup(P1_3);
DigitalOut gs_reset(p15), gs_wakeup(p14);
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
#endif

volatile int denki_flg = 0;
volatile int denki_capacity = 0;
volatile int denki_usage = 0;
volatile int year, month, day, hour, minute;

AnalogIn adtemp(p20);

void callback_http (int cid, int len) {
    static int n = 0;
//    static char buf[1024], data[80];
    static char buf[200], data[100];
    int i;
    int last = len;

  while (last) {
    len = gs.recv(cid, buf, last < sizeof(buf) ? last : sizeof(buf));
    last = last - len;

    for (i = 0; i < len; i ++) {
        if (buf[i] == '\r') continue;

        if (denki_flg <= 1) {
            // header
            if (strncmp(buf, "200 OK", 6) == 0) {
                i += 7;
                denki_flg = 2;
            }
            continue;
        }

        // body        
        if (buf[i] == '\n') {
            data[n] = 0;
            switch (denki_flg) {
            case 2:
                // update
                break;
            case 4:
                // capacity
                if (data[0] >= '0' && data[0] <= '9') {
                    denki_capacity = atoi(data);
                }
                break;
            case 7:
                // yosou1
                break;
            case 10:
                // yosou2
                break;
            default:
                // text
                if (data[0] == 'D' && data[1] == 'A') {
                    denki_flg = denki_flg < 100 ? 100 : 200;
                }
                break;
            }
            if (denki_flg > 200 && data[n - 1] >= '0' && data[n - 1] <= '9') {
                sscanf(data, "%d/%d/%d,%d:%d,%d", &year, &month, &day, &hour, &minute, &denki_usage);
            }
            n = 0;
            denki_flg ++;
        } else {
            // data
            if (n < sizeof(data) - 1) {
                data[n] = buf[i];
                n ++;
            }
        }

    }

  }
}

float get_temp () {
    float v, r, t;

    v = adtemp * VREF;
    r = v / ((VREF - v) / RU);
    t = (1.0 / ((1.0 / (T0 + 273.15)) + (log(r / R0) / B))) - 273.15;
    if (t < -50) t = 0;
    return t;
}

void Sleep () {
    __WFI();
}

int main() {
    int flg = 1, r;
    float denki_percentage = 0;
    Host host, ntp;
    int count = 0;
    time_t time;
    struct tm *t;

    initled();
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
    pc.baud(115200);
#endif
    gs_reset = 0;
    gs_wakeup = 1;
    wait_ms(100);
    gs_reset = 1;
    wait_ms(500);
    led1 = 1;

    if (gs.connect(GSSEC_WPA2_PSK, SSID, PASS, 1)) {
        return -1;
    }

    ntp.setName(NTP_HOST);
    gs.ntpdate(ntp, 0);
    wait(15);
    gs.ntpdate(ntp, 3 * 60 * 60);

#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
    pc.printf("Denki-yohou: %s\r\n", HTTP_HOST);
#endif
    host.setName(HTTP_HOST);

    startled();
    while(1) {
        gs.poll();
        
        if (flg || gs.getStatus() == GSSTAT_WAKEUP) {
            led1 = 1;
            if (gs.getStatus() == GSSTAT_WAKEUP) {
                gs.wakeup();
            }

            r = gs.httpGet(host, HTTP_URI, 0, &callback_http);
            if (r >= 0) {
                denki_percentage = (float)denki_usage / (float)denki_capacity * 100.0;
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
                pc.printf("%04d-%02d-%02d %02d:%02d :", year, month, day, hour, minute);
                pc.printf(" %d MW / %d MW", denki_usage * 10, denki_capacity * 10);
                pc.printf(" (%0.1f %%)\r\n", denki_percentage);
                led2 = denki_percentage >= 70 ? (denki_percentage >= 77.5 ? 1 : 0.5) : 0;
                led3 = denki_percentage >= 85 ? (denki_percentage >= 90 ? 1 : 0.5) : 0;
                led4 = denki_percentage >= 95 ? (denki_percentage >= 97 ? 1 : 0.5) : 0;
#elif defined(TARGET_LPC11U24)
                led2 = denki_percentage >= 70 ? 1 : 0;
                led3 = denki_percentage >= 85 ? 1 : 0;
                led4 = denki_percentage >= 95 ? 1 : 0;
#endif
            } else {
#if defined(TARGET_LPC1768) || defined(TARGET_LPC2368)
                pc.printf("http error\r\n");
#endif
            }
            flg = 0;
            
            wait(5);
            time = gs.getTime() + (9 * 3600);

            gs.standby(180000);
        }

        if (count == 0) { // 0sec
            // time
            t = localtime(&time);
            writeled(t->tm_hour * 100 + t->tm_min, 2, 0x0f, 0x0f);
        } else
        if (count > 0 && count < 4000) {
            // time blink
            if (count % 400 == 0) { // 0sec
                writeled(t->tm_hour * 100 + t->tm_min, 2, 0x0f, 0x0f);
            } else
            if (count % 400 == 200) { // 0.1sec
                writeled(t->tm_hour * 100 + t->tm_min, 0, 0x0f, 0x0f);
            }
        } else
        if (count == 4000) { // 10sec
            // denki yohou
            writeled(denki_percentage * 100, 2, 0x0e, 0);
        } else
        if (count == 6000) { // 15sec
            // temp.
            writeled(get_temp() * 10, 3, 0x07, 0);
        }

        if (count % 400 == 0) { // 0sec
            led1 = 1;
        } else
        if (count % 400 == 40) { // 0.1sec
            led1 = 0;

            time ++;
        }

        count ++;
        if (count >= 8000) count = 0; // 20sec

        Sleep();
    }
}
