#include "mbed.h"
#include "mbed_rpc.h"
#include "GSwifi.h"
 
#define SEC  GSwifi::SEC_OPEN
#define SSID "MBED"
#define PASS "1234567890"

#ifndef CFG_ENABLE_WEBSOCKET
#error Please enable "#define CFG_ENABLE_WEBSOCKET" in "GSwifi_conf.h"
#endif

DigitalOut led1(LED1), led2(LED2);
Serial pc(USBTX, USBRX);
//GSwifi gs(p13, p14, p12, P0_22, p20, NC, 115200); // mbed LPC1768
GSwifi gs(p13, p14, p12, p11, p20, NC, 115200); // mbed LPC1768
LocalFileSystem local("local");

void ws_server (int cid) {
    int i;
    char buf[40], outbuf[40];

    led2 = 1;
    i = gs.recv(cid, buf, sizeof(buf));
    if (i < 0) return;
    buf[i] = 0;

    RPC::call(buf, outbuf);
    printf("RPC %d '%s' '%s'\r\n", cid, buf, outbuf);

    gs.wsSend(cid, outbuf, strlen(outbuf));
    led2 = 0;
}
 
int main () {

    pc.baud(115200);

    gs.setAddress("192.168.1.1", "255.255.255.0", "192.168.1.1", "192.168.1.1", "www.mbed");
    gs.setSsid(SEC, SSID, PASS);
    if (gs.limitedap()) {
        pc.printf("error: limitedap\r\n");
        return -1;
    }

    RPC::add_rpc_class<RpcDigitalIn>();
    RPC::add_rpc_class<RpcDigitalOut>();
    RPC::add_rpc_class<RpcDigitalInOut>();
    RPC::add_rpc_class<RpcPwmOut>();
    RPC::add_rpc_class<RpcAnalogIn>();
    RPC::add_rpc_class<RpcAnalogOut>();

    gs.httpd(80);
    gs.httpdAttach("/ws/", &ws_server, 1);
    gs.httpdAttach("/", "/local/");
    printf("httpd ready\r\n");
    led1 = 1;

    for (;;) {
        gs.poll();

        if (pc.readable()) {
            if (pc.getc() == 'q') break;
        }
    }
    gs.dissociate();
    led1 = 0;
    return 0;
}
