/*
 * see: http://mbed.org/users/okini3939/notebook/wifi_webcam/
 *
 * using: http://mbed.org/users/va009039/code/USBHostC270_example/
 * using: http://mbed.org/users/gsfan/code/GSwifiInterface/
 */

#include "mbed.h"
#include "GSwifiInterface.h"
#include "USBHostC270.h"

#define SEC  GSwifi::SEC_OPEN
#define SSID "MBED"
#define PASS "1234567890"
#define MODE GSwifi::WM_LIMITEDAP

DigitalOut led1(LED1), led2(LED2), led3(LED3);
Serial pc(USBTX, USBRX);
LocalFileSystem local("local");
GSwifiInterface *gs;

int main() {
    Timer t;

    pc.baud(115200);
    pc.printf("GSwifi_ap_webcam\r\n");

    gs = new GSwifiInterface(p13, p14, p12, P0_22, p20, NC, 115200);
    wait_ms(300);
//    gs->init(); //Use DHCP
    gs->init("192.168.1.1", "255.255.255.0", "192.168.1.1", "192.168.1.1", "www.mbed");
    if (gs->connect(SEC, SSID, PASS, MODE)) return -1; // join the network
    NVIC_SetPriority(UART1_IRQn, 1);
    printf("IP Address is %s\r\n", gs->getIPAddress());

    gs->httpd();
    gs->httpdAttach("/", "/local/");

    USBHostC270* cam = new USBHostC270(C270_MJPEG, C270_160x120, _10FPS); // Logitech C270
//    USBHostC270* cam = new USBHostC270(C270_MJPEG, C270_320x240, _5FPS); // Logitech C270

    t.start();
    led1 = 1;
    for (;;) {
        gs->poll();

        if (!cam->connected()) {
            led2 = 1;
            if (t.read() > 0.5) {
                cam->connect();
                if (cam->connected()) printf("webcam has detected\r\n");
                t.reset();
            }
        } else {
            led2 = 0;
            cam->poll();
            if (t.read() > 10) {
                led3 = 1;
                uint8_t buf[1024*8];
                int r = cam->readJPEG(buf, sizeof(buf));
                if (r) {
                    FILE* fp = fopen("/local/photo.jpg", "wb");
                    if (fp) {
                        fwrite(buf, r, 1, fp);
                        fclose(fp);
                    }
                    printf("took a picture\r\n");
                }
                t.reset();
                led3 = 0;
            }
        }
    }
}
