
#define DATA_TYPE_AIR    1
#define DATA_TYPE_GROUND 2

struct AirData {
    uint8_t magic[4];
    int16_t seq;
    int16_t type;
    int16_t aileron;  // Right stick/L-R
    int16_t elevator; // Left stick/D-U
    int16_t throttle; // Right stick/D-U
    int16_t rudder;   // Left stick/L-R
    int16_t analog1;
    int16_t analog2;
    int16_t sw1;
    int16_t sw2;
    int16_t flags;
    uint8_t sum;
} __attribute__((packed));

struct GroundData {
    uint8_t magic[4];
    int16_t seq;
    int16_t type;
    int16_t uptime;
    int16_t battery;
    int16_t current;
    int32_t amphour;
    int16_t distance1, distance2;
    uint8_t gps[60];
    uint8_t compass[10];
    uint8_t sum;
} __attribute__((packed));

struct Status {
    int gps_date, gps_time, gps_lat, gps_lng, gps_h;
    int gps_sat, gps_type, gps_flg, gps_lost;
    int compass_x, compass_y, compass_z, compass;
    int uptime, battery, current, amphour;
    int distance1, distance2;
};

void recvRf (struct GroundData *recv_data, int rssi);
int sendRf (struct AirData *send_data);
void pollRf ();
int initRf ();

void parseGps (uint8_t *buf);
void parseCompass (uint8_t *buf);

void initGps ();

void log ();
int initMsd ();

