#include "mbed.h"
#include "drone.h"
#include "NECnfc.h"

#define RF_CHANNEL 34
#define RF_CHANNEL2 30

NECnfc rf(p13, p14, p11, p12, NC, 38400, NECnfc::TYPE_920MHz); // tx, rx, reset, wakeup, mode
//cts 12, rts 13
NECnfc rf2(p9, p10, NC, 38400, NECnfc::TYPE_920MHz); // tx, rx, reset, wakeup, mode

//static int air = NEC_DUMMYID;
const static int air = 0x4b800063;
static int seq = 1;

extern int rf_dual;

void isrRecv () {
    char buf[NEC_MAXLENGTH + 1];
    int i, len, dest, src;
    uint8_t sum = 0;

    len = rf.readData(&dest, &src, buf, sizeof(buf));
    if (len <= 0) return;

    for (i = 0; i < len; i ++) {
        sum += (uint8_t)buf[i];
    }
    if (sum) return; // sum error
    if (strncmp(buf, "Suge", 4) != NULL) return;
    rf_dual &= ~2;

    len --;
    buf[len] = 0;
    if (air != src) {
//        air = src;
        printf("new air %08x\r\n", air);
    }
//    recvRf((struct GroundData *)buf, rf.getRssi());
    recvRf((struct GroundData *)buf, 0);
}

void isrRecv2 () {
    char buf[NEC_MAXLENGTH + 1];
    int i, len, dest, src;
    uint8_t sum = 0;

    len = rf2.readData(&dest, &src, buf, sizeof(buf));
    if (len <= 0) return;

    if (strncmp(buf, "Suge", 4) != NULL) return;
    rf_dual |= 2;

    for (i = 0; i < len; i ++) {
        sum += (uint8_t)buf[i];
    }
    if (sum) return; // sum error

    len --;
    buf[len] = 0;
//    recvRf((struct GroundData *)buf, rf2.getRssi());
    recvRf((struct GroundData *)buf, 0);
}

int sendRf (struct AirData *send_data) {
    int i;
    uint8_t sum = 0;
    char *buf = (char*)send_data;

    memcpy(send_data->magic, "Suge", 4);
    send_data->type = DATA_TYPE_AIR;
    send_data->seq  = seq;
    seq ++;
    if (seq >= 0x10000) seq = 1;
    send_data->flags = rf_dual;

    for (i = 0; i < sizeof(struct AirData) - 1; i ++) {
        sum += (uint8_t)buf[i];
    }
    send_data->sum = ~sum + 1; // two's complement

    return rf.sendData(air, buf, sizeof(struct AirData));
}

void pollRf () {
    rf.poll();
    rf2.poll();
}

int initRf () {
    if (rf.setRfConfig(NECnfc::PWR_MAX, RF_CHANNEL, NECnfc::BAUD_50k)) return -1;
    rf.attach(&isrRecv);
    printf("RF %08x\r\n", rf.getId());

    if (rf2.setRfConfig(NECnfc::PWR_MAX, RF_CHANNEL2, NECnfc::BAUD_50k)) {;
        printf("RF2 error\r\n");
    } else {
        rf2.attach(&isrRecv2);
        printf("RF2 %08x\r\n", rf2.getId());
        rf_dual |= 1;
    }
    return 0;
}
