/*
 * APA102 (Adafruit DotStar LED Strip)
 */

#include "mbed.h"

#define LED_NUM 100
#define LED_GLOBAL 31 // brightness 0-31
#define LED_FREQ 500000 // spi

DigitalOut myled(LED1);
SPI spi(P0_21, P0_22, P1_15);

int led_buf[LED_NUM];

void dotStar () {
    int i;

    // start frame
    for (i = 0; i < 4; i ++) {
        spi.write(0);
    }
    // led frame
    for (i = 0; i < LED_NUM; i ++) {
        spi.write((7<<5) | LED_GLOBAL);
        spi.write((led_buf[i] >> 16) & 0xff); // B
        spi.write((led_buf[i] >> 8) & 0xff); // G
        spi.write(led_buf[i] & 0xff); // R
    }
    // end frame
    for (i = 0; i < 4; i ++) {
        spi.write(1);
    }
}

int main() {
    int i, c;
    int color = 1;

    spi.frequency(LED_FREQ);

    for (;;) {
        for (i = 0; i < LED_NUM; i ++) {
            c = ((color + i) % 7) + 1;
            led_buf[i] = (c & 4 ? 0xff0000 : 0) | (c & 2 ? 0xff00 : 0) | (c & 1 ? 0xff : 0);
        }
        dotStar();
        myled = !myled;
        color ++;
        if (color > 7) color = 1;
        wait(0.2);
    }
}
