/*
 * Control Art-Net from freepascal & delphi
 * (c) Rowan Maclachlan (hippy) rowanmac@optusnet.com.au [15d/01m/06y]
 *
 * Free for personal not-for-profit use only, please contact me if you are
 * using it in a commercial product, as i would like a copy :)
 *
 * http://members.westnet.com.au/rowanmac/
 *
 * for mbed ported by Suga 2011, 2017
 */

/** @file
 */

#ifndef _DmxArtNet_H_
#define _DmxArtNet_H_

#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"

#ifndef DMX_SIZE
#define DMX_SIZE 512
#endif

//#define ArtMaxUniv 16 // Universe
#define ArtMaxUniv 4 // Universe

//#define SizeRecvBuffer (530*4)
//#define SizeRecvBuffer 560
#define SizeRecvBuffer 1024

// Art-Net Standard Stuff
#define ArtHeaderID     "Art-Net" // packet header
#define ArtUDPPort      0x1936 // UDP port 6454 for Art-Net
#define ArtVersion      14    // Art-Net version

// Art-Net OpCodes - defines type of packet
#define OP_Output       0x5000 //Art-Net DMX Packet 'Output'
#define OP_Poll         0x2000 // ArtPoll
#define OP_PollReply    0x2100 // ArtPoll Reply
#define OP_Address      0x6000 // ArtAddress

#define OP_OpTodRequest 0x8000 
#define OP_OpTodData    0x8100 
#define OP_OpTodControl 0x8200 
#define OP_OpRdm        0x8300 
#define OP_OpRdmSub     0x8400 

#define OP_IpProg       0xf800 // IpProg
#define OP_IpProgReply  0xf900 // IpProgReply

#define StyleNode       0
#define StyleServer     1

#define STR_LongName    "MbedArtNode - By Suga (2017), Rowan Maclachlan (2005)"
#define STR_ShortName   "MbedArtNode"
#define OEM_ID          0x7ff7

#define OP_Poll_TalkToMe_SendMeDiag     (1<<2)
#define OP_Poll_TalkToMe_DiagUnicast    (1<<3)
#define OP_Poll_TalkToMe_DisableVLC     (1<<4)

#define OP_PollRep_GoodIn_ReceiveError  (1<<2)
#define OP_PollRep_GoodIn_Disabled      (1<<3)
#define OP_PollRep_GoodIn_DmxText       (1<<4)
#define OP_PollRep_GoodIn_DmxSip        (1<<5)
#define OP_PollRep_GoodIn_DmxTest       (1<<6)
#define OP_PollRep_GoodIn_Received      (1<<7)

#define OP_PollRep_GoodOut_sACN         (1<<0)
#define OP_PollRep_GoodOut_ModeLTP      (1<<1)
#define OP_PollRep_GoodOut_ShortDetected (1<<2)
#define OP_PollRep_GoodOut_MergeArtNet  (1<<3)
#define OP_PollRep_GoodOut_DmxText      (1<<4)
#define OP_PollRep_GoodOut_DmxSip       (1<<5)
#define OP_PollRep_GoodOut_DmxTest      (1<<6)
#define OP_PollRep_GoodOut_Transmitted  (1<<7)

#define OP_IpProg_Command_ProgPort      (1<<0)
#define OP_IpProg_Command_ProgNetmask   (1<<1)
#define OP_IpProg_Command_ProgIpaddress (1<<2)
#define OP_IpProg_Command_Prog3Param    (1<<3)
#define OP_IpProg_Command_EnableDhcp    (1<<6)
#define OP_IpProg_Command_EnableProg    (1<<7)


// a DMX universe
//#define DMXArray = array[0..511] of byte;

struct ArtAddr {
     unsigned char IP[4]; // ip addess 0.1.2.3
     unsigned short Port;
} __attribute__((packed));

struct ArtPacketHeader {
     char ID[8];
     unsigned short OpCode; // 0x5000
} __attribute__((packed));


// dmx transport packet
struct ArtDMX_Packet {
     char ID[8];
     unsigned short OpCode; // 0x5000
     unsigned char VersionH; // 0
     unsigned char Version; // 14
     unsigned char Sequence; // 0
     unsigned char Physical; // 0
     unsigned short Universes;
     unsigned short Length; // size of data segment
     unsigned char Data[DMX_SIZE]; // data segment
} __attribute__((packed));

struct ArtPoll_Packet {
     char ID[8];
     unsigned short OpCode; // 0x2000
     unsigned char VersionH; // 0
     unsigned char Version; // 14
     unsigned char TalkToMe; // 0
     unsigned char Priority;
} __attribute__((packed));

// a responce to a artpoll packet
struct ArtPollReply_Packet {
     char ID[8];
     unsigned short OpCode; // 0x2100
     struct ArtAddr Addr; // our ip address
     unsigned char VersionH;
     unsigned char Version;
     unsigned char NetSwitch;
     unsigned char SubSwitch;
     unsigned short OEM;
     char UbeaVersion;
     char Status;
     unsigned short EstaMan;
     char ShortName[18];
     char LongName[64];
     char NodeReport[64];
     unsigned char NumPortsH;
     unsigned char NumPorts;
     unsigned char PortType[4];
     unsigned char GoodInput[4];
     unsigned char GoodOutput[4];
     unsigned char Swin[4];
     unsigned char Swout[4];
     unsigned char SwVideo;
     unsigned char SwMacro;
     unsigned char SwRemote;
     unsigned char Spare[3]; // three spare bytes
     unsigned char Style;
     unsigned char Mac[6];
     unsigned char BindIp[4];
     unsigned char BindIndex;
     unsigned char Status2;
     unsigned char Padding[26]; // padding
} __attribute__((packed));

struct ArtIpProg_Packet {
     char ID[8];
     unsigned short OpCode; // 0xf800
     unsigned char VersionH; // 0
     unsigned char Version; // 14
     unsigned char Filler1;
     unsigned char Filler2;
     unsigned char Command;
     unsigned char Filler4;
     unsigned char ProgIp[4];
     unsigned char ProgSm[4];
     unsigned char ProgPortH;
     unsigned char ProgPort;
     unsigned char Padding[8];
} __attribute__((packed));

struct ArtIpProgReply_Packet {
     char ID[8];
     unsigned short OpCode; // 0xf900
     unsigned char VersionH; // 0
     unsigned char Version; // 14
     unsigned char Filler1;
     unsigned char Filler2;
     unsigned char Filler3;
     unsigned char Filler4;
     unsigned char ProgIp[4];
     unsigned char ProgSm[4];
     unsigned char ProgPortH;
     unsigned char ProgPort;
     unsigned char Status;
     unsigned char Padding[7];
} __attribute__((packed));

struct ArtAddress_Packet {
     char ID[8];
     unsigned short OpCode; // 0x6000
     unsigned char VersionH;
     unsigned char Version;
     unsigned char NetSwitch;
     unsigned char BindIndex;
     char ShortName[18];
     char LongName[64];
     unsigned char Swin[4];
     unsigned char Swout[4];
     unsigned char SubSwitch;
     unsigned char SwVideo;
     unsigned char Command;
} __attribute__((packed));

struct ArtTodRequest_Packet {
     char ID[8];
     unsigned short OpCode; // 0x8300
     unsigned char VersionH;
     unsigned char Version;
     unsigned char Filler1;
     unsigned char Filler2;
     char Spare[7];
     char Net;
     char Command;
     char AddCount;
     char Address[32];
} __attribute__((packed));

struct ArtTodData_Packet {
     char ID[8];
     unsigned short OpCode; // 0x8300
     unsigned char VersionH;
     unsigned char Version;
     unsigned char RdmVersion;
     unsigned char Port;
     char Spare[6];
     char BindIndex;
     char Net;
     char CommandResponse;
     char Address;
     char UidTotalH;
     char UidTotalL;
     char BlockCount;
     char UidCount;
     char ToD[6];
} __attribute__((packed));

struct ArtTodControl_Packet {
     char ID[8];
     unsigned short OpCode; // 0x8300
     unsigned char VersionH;
     unsigned char Version;
     unsigned char Filler1;
     unsigned char Filler2;
     char Spare[7];
     char Net;
     char Command;
     char Address;
} __attribute__((packed));

struct ArtRdm_Packet {
     char ID[8];
     unsigned short OpCode; // 0x8300
     unsigned char VersionH;
     unsigned char Version;
     unsigned char RdmVersion;
     unsigned char Filler2;
     char Spare[7];
     char Net;
     char Command;
     char Address;
     char RdmPacket[];
} __attribute__((packed));

struct ArtRdmSub_Packet {
     char ID[8];
     unsigned short OpCode; // 0x8400
     unsigned char VersionH;
     unsigned char Version;
     unsigned char RdmVersion;
     unsigned char Filler2;
     char uid[6];
     char Spare1;
     char CommandClass;
     short ParameterId;
     short SubDevice;
     short SubCount;
     char Spare[4];
     short data[];
} __attribute__((packed));


struct ArtPorts_Config {
     unsigned char PortType[ArtMaxUniv];
     unsigned char GoodInput[ArtMaxUniv];
     unsigned char GoodOutput[ArtMaxUniv];
     unsigned char Swin[ArtMaxUniv];
     unsigned char Swout[ArtMaxUniv];
};

/** DmxArtNet class
 */
class DmxArtNet {
public:
    unsigned short NetSwitch;
    char BindIpAddress[16]; // Local IP Address to bind onto
    char BCastAddress[16]; // address to broadcast on
    char SubNetMask[16], DGateWay[16];
    int UdpPort, OemId;

    DmxArtNet ();

    /** create network socket, setup for NetworkWork
     * @return true if socket creation succeded
     */
    int Init();

    /** socket shutdown
     */
    void Done();

    /** last error
     * @retval 0 ok
     */
    int LastError() {
        return LError;
    }
    /** returns descrip of last error
     * @return descrip of last error
     */
    char *LastErrorString() {
        return LErrorString;
    }
    /** clear error
     */
    void ClearError();

    /** Send
     * send an array [0..511] of (length) bytes representing the dmx you want to send to
     * univ[0..15] ,  physical is info only, can be the universe number or port of device
     */
    int Send_ArtDmx(int univ, int physical, char *data, int length);
    /** execute often
     * returns true if something happened
     * @return 1 something happened
     */
    int Work();
/*
    void WorkAddress (ArtAddress_Packet *address);
    void WorkIpProg (ArtIpProg_Packet *ipprog);
*/
    unsigned char *DmxIn[ArtMaxUniv]; // Recieved ArtDMX, 16 Dmx Arrays
    volatile int LastRecievedUniverse; // the number of the last recieved universe

    struct ArtPollReply_Packet ArtPollReply; // a response to ArtPoll
                                      // contains many variables you may set
    struct ArtPorts_Config ArtPorts;

    void InitArtPollReplyDefaults();
    int SendArtPollReply();
    int SendArtIpProgReply();
    int SendArtTodData (int n);

    void attach (void (*handler)(struct ArtPacketHeader *, int));

    void bcast(char *dest, char *ipaddr, char *netmask);

private:
    UDPSocket _art; // the network socket
    struct ArtPacketHeader ArtHead; // packet header
    struct ArtDMX_Packet ArtDMX; // an Art-Net DMX Packet
    struct ArtPoll_Packet ArtPoll; // an Art-Poll Packet
    unsigned char buf[SizeRecvBuffer]; // a temp buffer
    struct ArtAddr localaddr;
    int LError;
    char LErrorString[40];

    int makeword16 (int lsb, int msb);

    void Init_ArtDMX();
    void SocketErrorOccured(char *proc);

    static void task_UDPSocket (void const *arg);
    void on_UDPSocketEvent ();

    void (*cb_ArtParser)(struct ArtPacketHeader *art, int len);

    Endpoint RemoteSin;
    volatile int rxlen;
    Thread *thread;
};
#endif
