/*
 * NEC 950MHz RF module
 * H001-000003-001
 */

#include <inttypes.h>

//#define CH 17 // 17-31
#define TIMEOUT 10 // ms

#define MSGID_ACK           0x00
#define MSGID_NOACK         0x01
#define MSGID_SEARCH        0x10
#define MSGID_SEND_DAT      0x11
#define MSGID_RESEND        0x12
#define MSGID_SEND_NOACK    0x13
#define MSGID_ENERGY_DETECT 0x16
#define MSGID_SEND_CMD      0x17
#define MSGID_WRITE_RFCONF  0x21
#define MSGID_READ_RSSI     0x24
#define MSGID_READ_CONFIG   0x29
#define MSGID_WRITE_CONFIG  0x2A
#define MSGID_READ_DEFAULT  0x7D
#define MSGID_WRITE_DEFAULT 0x7E
#define MSGID_RESET         0x77

#define POWER_LOW           0x00
#define POWER_MID           0x01
#define POWER_HIGH          0x02

#define BAUD_9600           0x02
#define BAUD_50k            0x06
#define BAUD_100k           0x07

#define UART_4800           0x01
#define UART_9600           0x02
#define UART_19200          0x04
#define UART_38400          0x05
#define UART_56700          0x06
#define UART_115200         0x08

struct ifMessage {
    uint16_t start;
    uint8_t  length;
    uint8_t  msgid;
    uint8_t  msgno;
    uint32_t dstid;
    uint32_t srcid;
    uint8_t  parameter[242];
} __attribute__((packed));


int send_rf (int msgid, unsigned long dest, char *param, int len);
int read_rf (struct ifMessage *ifmsg);
int init_rf (int ch);
