/*
 * NEC 950MHz RF module
 * H001-000003-001
 */

#include "mbed.h"
#include "NEC950MHz.h"
#include "dbg.h"
#include <string.h>

#define RXD p10
#define TXD p9
#define RST p12


// host to network short
#define htons( x ) ( (( (x) << 8 ) & 0xFF00) | (( (x) >> 8 ) & 0x00FF) )
#define ntohs( x ) htons(x)
// host to network long
#define htonl( x ) ( (( (x) << 24 ) & 0xFF000000)  \
                   | (( (x) <<  8 ) & 0x00FF0000)  \
                   | (( (x) >>  8 ) & 0x0000FF00)  \
                   | (( (x) >> 24 ) & 0x000000FF)  )
#define ntohl( x ) htonl(x)


static Serial rf(TXD, RXD);
static DigitalOut rst(RST);

int send_rf (int msgid, unsigned long dest, char *param, int len) {
    int i;
    static int msgno = 0;
    struct ifMessage ifmsg;
    unsigned char *buf = (unsigned char *)&ifmsg;

    if (len > 240) len = 240;
    msgno ++;
    ifmsg.start = htons(0x0f5a);
    ifmsg.length = 13 + len;
    ifmsg.msgid = msgid;
    ifmsg.msgno = msgno;
    ifmsg.dstid = htonl(dest);
    ifmsg.srcid = htonl(0xffffffff);
    memcpy(ifmsg.parameter, param, len);
    DBG("send_rf %d / %d\r\n", ifmsg.length, len);
    
    for (i = 0; i < ifmsg.length; i ++) {
        rf.putc(buf[i]);
    }

    return ifmsg.msgno;
}

int read_rf (struct ifMessage *ifmsg) {
    Timer timeout;
    int i = 0, len = 0;
    unsigned char buf[sizeof(struct ifMessage)];

    timeout.start();
    while (timeout.read_ms() < TIMEOUT) {
        if (rf.readable()) {
            buf[i] = rf.getc();
            if (i == 0 && buf[i] == 0x0f) {
                i ++;
            } else
            if (i == 1 && buf[i] == 0x5a) {
                i ++;
            } else
            if (i == 2) {
                len = buf[i];
                i ++;
            } else
            if (i >= 3) {
                i ++;
                if (i >= len || i >= sizeof(buf)) break;
            }
            timeout.reset();
        }
    }
    timeout.stop();
 
    if (len) {
        DBG("read_rf %d / %d\r\n", i, len);
        memcpy(ifmsg, buf, len);
    }
    return len;
}

int init_rf (int ch) {
    int no;
    struct ifMessage ifmsg;
    // high power, 100kbps, retry 0
    char rfconf[] = {POWER_HIGH, ch, BAUD_100k, 1, 0, UART_115200, 1, 0xff, 0xff,
        0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
        0x00, 0x00, 0x83, 0x41};
    
    rf.baud(38400);

    rst = 0; // reset
    wait_ms(50);
    rst = 1;
    wait_ms(100);

    no = send_rf(MSGID_WRITE_CONFIG, 0xffffffff, rfconf, sizeof(rfconf));
    DBG("rfconf %d\r\n", no);
    // responce
    if (! read_rf(&ifmsg) || ifmsg.msgid != MSGID_ACK || ifmsg.msgno != no) {
        return -1;
    }

    rf.baud(115200);

    return 0;
}
