#include "mbed.h"

#define     IAP_LOCATION    0x1fff1ff1
typedef     void (*IAP_call)(unsigned int [], unsigned int []);

IAP_call        iap_entry = reinterpret_cast<IAP_call>(IAP_LOCATION);
unsigned int    IAP_command[ 5 ];
unsigned int    IAP_result[ 5 ];

int IAP_read_serial( void ) {
    
    IAP_command[ 0 ]    = 58; // IAPCommand_Read_device_serial_number
    
    iap_entry( IAP_command, IAP_result );
    
    //  return ( (int)IAP_result[ 0 ] );
    return ( (int)IAP_result[ 1 ] );    //  to return the number itself (this command always returns CMD_SUCCESS)
}

extern "C" void mbed_mac_address(char *s) {
    char mac[6] = {0x02, 0x00, 0x00, 0x00, 0x00, 0x00};
    int *serial = (int*)&mac[2];
    
    *serial = IAP_read_serial();
    memcpy(s, mac, 6);
}  
