/*
 * DAC5578 (8bit)
 * DAC6578 (10bit)
 * DAC7578 (12bit)
 */

#ifndef __DACx578_h__
#define __DACx578_h__

#include "mbed.h"

#define DACx578_I2C_ADDR 0x90

class DACx578 {
public:
    enum DEVICE {
        DAC5578 = 0,
        DAC6578 = 2,
        DAC7578 = 4,
    };

    DACx578 (PinName sda, PinName scl, int addr, enum DEVICE device = DAC5578);
    DACx578 (I2C& i2c, int addr, enum DEVICE device = DAC5578);

    int init ();
    int write (int channel, int value, int ldac = 0);
    int ldacWrite (int channel, int value);
    int update (int channel);

protected:
    I2C _i2c;
    int _addr;
    int _device;
};

#endif
