/*
 * DAC5578 (8bit)
 * DAC6578 (10bit)
 * DAC7578 (12bit)
 */

#include "DACx578.h"

DACx578::DACx578 (PinName sda, PinName scl, int addr, enum DEVICE device) : _i2c(sda, scl) {
    _addr = addr;
    _device = device;
    init();
}

DACx578::DACx578 (I2C &i2c, int addr, enum DEVICE device) : _i2c(i2c) {
    _addr = addr;
    _device = device;
    init();
}

int DACx578::init () {
    char buf[3];

    buf[0] = 0x70; // reset
    buf[1] = 0x00;
    buf[2] = 0x00;
    if (_i2c.write(_addr, buf, 3)) return -1;
    wait_ms(10);

    buf[0] = 0x40; // power on
    buf[1] = 0x1f;
    buf[2] = 0xe0;
    if (_i2c.write(_addr, buf, 3)) return -1;
/*
    buf[0] = 0x60; // ignore LDAC
    buf[1] = 0xff;
    buf[2] = 0x00;
    if (_i2c.write(_addr, buf, 3)) return -1;
*/
    return 0;
}

int DACx578::write (int channel, int value, int ldac) {
    char buf[3];

    buf[0] = (ldac ? 0x30 : 0x00) | (channel & 0x0f); // Individual Software LDAC / Input Register
    buf[1] = (value >> _device) & 0xff;
    buf[2] = ((8 - value) << _device) & 0xff;
    return _i2c.write(_addr, buf, 3);
}

int DACx578::ldacWrite (int channel, int value) {
    char buf[3];

    buf[0] = 0x20 | (channel & 0x0f); // Global Software LDAC
    buf[1] = (value >> _device) & 0xff;
    buf[2] = ((8 - value) << _device) & 0xff;
    return _i2c.write(_addr, buf, 3);
}

int DACx578::update (int channel) {
    char buf[3];

    buf[0] = 0x10 | (channel & 0x0f); // Register Update
    buf[1] = 0;
    buf[2] = 0;
    return _i2c.write(_addr, buf, 3);
}
