#include "mbed.h"
#include "OBD2.h"

DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);
Serial pc(USBTX, USBRX);
OBD2 obd(p30, p29);

float readObd2 (int cmd) {

    if (obd.request(cmd)) {
        return -1;
    }
    return obd.read();
}

int main() {
    int i;
    float f;

    pc.baud(115200);
    pc.printf("--- OBD2\n\r");
    led1 = 1;

    for (;;) {
        if (pc.readable()) {
            i = 0;
            switch (pc.getc()) {
            case '1': i = ENGINE_LOAD; break;
            case '2': i = THROTTLE; break;
            case '3': i = FUEL_LEVEL; break;
            case '4': i = ENGINE_COOLANT_TEMP; break;
            case '5': i = INTAKE_TEMP; break;
            case '6': i = AMB_AIR_TEMP; break;
            case '7': i = INTAKE_PRESSURE; break;
            case '8': i = ENGINE_RPM; break;
            case '9': i = VEHICLE_SPEED; break;
            }

            if (i) {
                f = readObd2(i);
                pc.printf("PID=%02x, Result=%f\r\n", i, f);
            }
            led2 = !led2;
        }
    }
}
