/*
 * AMS, Franklin Lightning Sensor "AS3935" Library
 * Copyright (c) 2015 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */
// http://ams.com/eng/Products/Lightning-Sensor/Franklin-Lightning-Sensor/AS3935

#ifndef _AS3935_h_
#define _AS3935_h_

#include "mbed.h"

class AS3935 {
public:
    /**
     * @param i2c I2C class
     * @param irq IRQ pin
     */
    AS3935 (I2C &i2c, PinName irq);
    /**
     * @param sda I2C SDA pin
     * @param scl I2C SCL pin
     * @param irq IRQ pin
     */
    AS3935 (PinName sda, PinName scl, PinName irq);

    /** Initialize AS3935
     */
    void init ();

    /** Read lightning signal validation
     * @param energy (return) Energy of the Single Lightning
     * @param distance (return) Distance estimation
     */
    void read (int &energy, int &distance);

    /** Attach a function, lightning interrupt
     * @param fptr pointer to a void function, or 0 to set as none
     */
    void attach(void (*fptr)(void)) { 
        _func.attach(fptr);
    }
    /** Attach a member function, lightning interrupt
     * @param tptr pointer to the object to call the member function on
     * @param mptr pointer to the member function to be called
     */
    template<typename T>
    void attach(T *tptr, void (T::*mptr)(void)) { 
        _func.attach(tptr, mptr); 
    }

private:
    I2C _i2c;
    InterruptIn _irq;
    int _freq;
    int _mode;
    int _type;

    FunctionPointer _func;

    void calib_lco ();
    void isr_freq ();
    void isr_lightning ();
};

#endif
