/*
 * mbed library to use a I2C LCD
 * Copyright (c) 2010 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */
 
#ifndef G7Digits_H
#define G7Digits_H

#include "mbed.h"

#define G7DIGITS_LED1 p5
#define G7DIGITS_LED2 p25
#define G7DIGITS_LED3 p24
#define G7DIGITS_SW1 p29
#define G7DIGITS_SW2 p11
#define G7DIGITS_SW3 p30
#define G7DIGITS_BZ p21

#define G7DIGITS_D0 p23
#define G7DIGITS_D1 p12
#define G7DIGITS_D2 p6
#define G7DIGITS_D3 p7
#define G7DIGITS_DP p5
#define G7DIGITS_COM0 p27
#define G7DIGITS_COM1 p28
#define G7DIGITS_EN p22

#define G7DIGITS_VR1 p15
#define G7DIGITS_VR2 p16
#define G7DIGITS_VR3 p17
#define G7DIGITS_PHOTO p18
#define G7DIGITS_TEMP p19
#define G7DIGITS_VOLT p20

class G7Digits : public Base {
public:
    G7Digits(int p_beta = 0);

    void begin();
    int write(int);
    void ctrl(char, char, char, char);
    void dot(char, char, char, char);

private:
    Ticker int_g7d;
    DigitalOut g7d_d0, g7d_d1, g7d_d2, g7d_d3, g7d_com0, g7d_com1, g7d_en;
    DigitalInOut g7d_dp;

    int beta;
    volatile int digit_count, digit_dot, digit_ctrl, digit_pin;
    volatile unsigned int digit_num;

    void int_g7digits();
};

#endif