/*
 * mbed library to use a 4 Digits Shield
 * Copyright (c) 2010 Hiroshi Suga
 * Released under the MIT License: http://mbed.org/license/mit
 */

#include "mbed.h"
#include "G7Digits.h"

G7Digits::G7Digits(int p_beta) : g7d_d0(G7DIGITS_D0), g7d_d1(G7DIGITS_D1), g7d_d2(G7DIGITS_D2), g7d_d3(G7DIGITS_D3), g7d_dp(G7DIGITS_DP), g7d_com0(G7DIGITS_COM0), g7d_com1(G7DIGITS_COM1), g7d_en(G7DIGITS_EN) {
    beta = p_beta;

    digit_count = 0;
    digit_num = 0;
    digit_dot = 0;
    digit_ctrl = 0x0f;
}

void G7Digits::begin() {
    int_g7d.attach(this, &G7Digits::int_g7digits, 0.0025);
}

void G7Digits::int_g7digits() {
    int n;

    g7d_en = 0;

    if (beta) {
        if (digit_count == 0) {
            g7d_com0 = 0;
            g7d_com1 = 0;
        } else
        if (digit_count == 1) {
            g7d_com0 = 1;
            g7d_com1 = 1;
        } else
        if (digit_count == 2) {
            g7d_com0 = 0;
            g7d_com1 = 1;
        } else
        if (digit_count == 3) {
            g7d_com0 = 1;
            g7d_com1 = 0;
        }
    } else {
        g7d_com0 = (digit_count & 0x01) ? 1 : 0;
        g7d_com1 = (digit_count & 0x02) ? 1 : 0;
    }

    n = (digit_num >> (12 - (4 * digit_count))) & 0x0f;
    g7d_d0 = (n & 0x01) ? 1 : 0;
    g7d_d1 = (n & 0x02) ? 1 : 0;
    g7d_d2 = (n & 0x04) ? 1 : 0;
    g7d_d3 = (n & 0x08) ? 1 : 0;

    if (digit_dot & (1 << digit_count)) {
        digit_pin = g7d_dp.read();
        g7d_dp = 0;
        g7d_dp.output();
    } else {
        if (digit_pin || g7d_dp.read()) {
            g7d_dp = 1;
            g7d_dp.output();
        } else {
            g7d_dp.input();
        }
    }

    if (digit_ctrl & (1 << digit_count))
        g7d_en = 1;

    digit_count ++;
    if (digit_count >= 4) digit_count = 0;
}

int G7Digits::write (int num)
{
    digit_num = num % 10;
    digit_num |= ((num / 10) % 10) << 4;
    digit_num |= ((num / 100) % 10) << 8;
    digit_num |= (unsigned int)((num / 1000) % 10) << 12;

    return digit_num;
}

void G7Digits::ctrl (char d1, char d2, char d3, char d4)
{
    digit_ctrl = (d1 ? 1 : 0) | (d2 ? 2 : 0) | (d3 ? 4 : 0) | (d4 ? 8 : 0);
}

void G7Digits::dot (char d1, char d2, char d3, char d4)
{
    digit_dot = (d1 ? 1 : 0) | (d2 ? 2 : 0) | (d3 ? 4 : 0) | (d4 ? 8 : 0);
}
