//  stepper motor operation sample (learn it step by step).
//  showing how to control a unipolar stepper motor by mbed digital output ports.
//
//  version 8 : motor control by function

#include "mbed.h"

BusOut      motor_out( p26, p25, p24, p23 );

#define     CW  0   //  CLOCKWISE
#define     CCW 1   //  COUNTERCLOCKWISE

void rotate( int steps, float speed, char direction );

int main()
{
    while(1) {
        rotate( 20,  50,  CW );
        rotate( 20,  50, CCW );
        rotate( 40, 100,  CW );
        rotate( 40, 100, CCW );
    }
}

void rotate( int steps, float speed, char direction )
{
    static char pattern[]   = { 0x3, 0x6, 0xC, 0x9 };
    static int  state       = 0;

    for ( int i = 0; i < steps; i++ ) {
        motor_out   = pattern[ state & 0x3 ];
        state      += direction ? -1 : 1;
        wait( 1.0 / speed );
    }
}

