#define     TEST_ON_MBED

#ifdef      TEST_ON_MBED
#include    "mbed.h"
#else
#include    <lpc17xx.h>
#include    <absacc.h>
#endif

void            IAP_Write(void);

#ifdef      TEST_ON_MBED
unsigned char   *a;
unsigned char   ram_buffer[ 5 + 3 ];
#else
unsigned char   a[5] at(0x10000400);
#endif

unsigned int    command[ 5 ];
unsigned int    result[ 5 ];
typedef void    (*IAP)( unsigned int [], unsigned int[] );

IAP iap_entry   = (IAP)0x1FFF1FF1;

#define         FLASH_TARGET_ADDR   ((char *)0x00008100)
#define         FLASH_TARGET_SECTOR 8

int main(void)
{
    unsigned char   i = 0;

    a   = (unsigned char *)((unsigned long)ram_buffer & ~0x3);  //  to align to word boundary

    for( i = 0; i < 5; i++ )
        a[ i ]  = i;

    for( i = 0; i < 5; i++ )
        printf( "RAM   : *((char *)0x%08X) == 0x%02X\r\n", (unsigned long)a + i, *(a + i) );

    IAP_Write();

    char    *cp = FLASH_TARGET_ADDR;

    for( i = 0; i < 5; i++, cp++ )
        printf( "flash : *((char *)0x%08X) == 0x%02X\r\n", (unsigned long)cp, *cp );
}

void IAP_Write(void)
{
    //  blank check
    
    command[0]  = 53;                   //  "blank check" command
    command[1]  = FLASH_TARGET_SECTOR;  //  Start sector number is 8
    command[2]  = FLASH_TARGET_SECTOR;  //  Finish sector number is 8
    iap_entry( command, result );

    printf( "error code for \"blank check\" = %d\r\n", result[ 0 ] );

    //  if the sector is not blank
    
    if ( result[ 0 ] ) {

        //  prepare for erasing
        
        command[0]  = 50;                   //  "prepare" command
        command[1]  = FLASH_TARGET_SECTOR;  //  Start sector number is 8
        command[2]  = FLASH_TARGET_SECTOR;  //  Finish sector number is 8
        iap_entry( command, result );

        printf( "error code for \"prepare\" = %d\r\n", result[ 0 ] );

        //  erase

        command[0]  = 52;                   //  "erase" command
        command[1]  = FLASH_TARGET_SECTOR;  //  Start sector number is 8
        command[2]  = FLASH_TARGET_SECTOR;  //  Finish sector number is 8
        command[3]  = 96000;                //  Frequency in khz
        iap_entry( command, result );

        printf( "error code for \"erase\" = %d\r\n", result[ 0 ] );
    }

    //  prepare for writing

    command[0]  = 50;                   //  "prepare" command
    command[1]  = FLASH_TARGET_SECTOR;  //  Start sector number is 8
    command[2]  = FLASH_TARGET_SECTOR;  //  Finish sector number is 8
    iap_entry( command, result );

    printf( "error code for \"prepare\" = %d\r\n", result[ 0 ] );

    //  write

    command[0]  = 51;                               //  "copy from ram to flash" command
    command[1]  = (unsigned int)FLASH_TARGET_ADDR;  //  Addrees of Flash
    command[2]  = (unsigned int)a;                  //  Addrees of Sram
    command[3]  = 256;                              //  How many bytes want to transfer
    command[4]  = 96000;                            //  Frequency in khz
    iap_entry( command, result );

    printf( "error code for \"copy from ram to flash\" = %d\r\n", result[ 0 ] );

    command[0]  = 56;                               //  "compare" command
    command[1]  = (unsigned int)FLASH_TARGET_ADDR;  //  Addrees of Flash
    command[2]  = (unsigned int)a;                  //  Addrees of Sram
    command[3]  = 4;                                //  data size (only 4 bytes are compared because it should be multiple of 4)
    iap_entry( command, result );

    printf( "error code for \"compare\" = %d\r\n", result[ 0 ] );
}