#include "test_LM75B.h"

test_LM75B::test_LM75B( PinName sda, PinName scl, char address ) 
    : i2c_p( new I2C( sda, scl ) ), i2c( *i2c_p ), adr( address )
{
    init();
}

test_LM75B::test_LM75B( I2C &i2c_obj, char address )
    : i2c_p( NULL ), i2c( i2c_obj ), adr( address )
{
    init();
}

test_LM75B::~test_LM75B()
{
    if ( NULL != i2c_p )
        delete  i2c_p;
}

void test_LM75B::init( void )
{
    char    command[ 2 ];

    command[ 0 ]    = LM75B_Conf;
    command[ 1 ]    = 0x00;

    i2c.write( adr, command, 2 );
}

float test_LM75B::read( void )
{
    char    command[ 2 ];

    command[ 0 ]    = LM75B_Temp;

    i2c.write( adr, command, 1 );  // Send command string
    i2c.read(  adr, command, 2 );  // read two bytes data

    return ( (float)( (command[ 0 ] << 8)| command[1] ) / 256.0 );
}

test_LM75B::operator float( void )
{
    return( read() );
}
