#include "mbed.h"

PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);

PwmOut  led[ 4 ]    = {led4, led3, led2, led1 };

#define     UPDATE_RATE     100.0

class Blinker {
public:

    typedef enum  {
        OFF,
        ON,
        STAY,
        UP,
        DOWN,
        UPDOWN
    } Mode;

    Blinker( PinName pin ) :
            output( pin ),
            mode( UPDOWN ),
            state( false ),
            intensity( 0.0 ),
            rate( 1.0 / UPDATE_RATE ),
            direction( true ) {
        t.attach( this, &Blinker::blinker_maintain, 1.0 / UPDATE_RATE );
        output.period_ms( 1 );
        output  = intensity;
    }

    void start( void ) {
        state   = true;
    }

    void stop( void ) {
        state   = false;
    }

    void set_mode( Mode m ) {
        mode   = m;
    }

    void set_initial_intensity( float v ) {
        intensity   = v;
    }

    void set_frequency( float f ) {
        rate    = f / UPDATE_RATE;
    }

private:
    void blinker_maintain( void ) {

        if ( OFF == state )
            return;

        switch ( mode ) {
            case OFF :
                intensity   = 0.0;
                break;
            case ON :
                intensity   = 1.0;
                break;
            case STAY :
                break;
            case UP :
                intensity   += rate;
                intensity   = (1.0 < intensity) ? 0.0 : intensity;
                break;
            case DOWN :
                intensity   -= rate;
                intensity   = (intensity < 0.0) ? 1.0 : intensity;
                break;
            case UPDOWN :
                direction   = (intensity <= 0.0) ? true  : direction;
                direction   = (1.0 <= intensity) ? false : direction;
                intensity   += direction ? (rate * 2.0) : -(rate * 2.0);
                break;
            default :
                break;
        }

        output  = intensity * intensity;
    }

    PwmOut  output;
    Ticker      t;

    Mode    mode;
    int     state;
    float   intensity;
    float   rate;
    float   direction;
};

//Blinker b( LED1 );
Blinker b[ 4 ]    = { LED4, LED3, LED2, LED1 };


int main() {


    for ( int i = 0; i < 4; i++ ) {
        b[ i ].set_frequency( 2 );
        b[i].start();
    }

    while ( 1 ) {

        for ( int i = 0; i < 4; i++ ) {
            b[ i ].set_mode( Blinker::DOWN );
            b[ i ].set_initial_intensity( 0.25 * (float)i );
        }

        wait( 2.0 );

        for ( int n = 0; n < 40; n++ ) {
            for ( int i = 0; i < 4; i++ ) {
                b[ i ].set_mode( rand() & 0x1 ? Blinker::ON : Blinker::OFF );
            }
            wait( 0.05 );
        }

        for ( int i = 0; i < 4; i++ ) {
            b[ i ].set_mode( Blinker::DOWN );
            b[ i ].set_initial_intensity( 1.0 - (0.25 * (float)i) );
        }

        wait( 2.0 );

        for ( int i = 0; i < 4; i++ ) {
            b[ i ].set_mode( Blinker::UPDOWN );
            b[ i ].set_initial_intensity( 0 );
        }

        wait( 2.0 );

        for ( int i = 0; i < 4; i++ ) {
            b[ i ].set_mode( Blinker::UPDOWN );
            b[ i ].set_initial_intensity( (i & 0x1) ? 1 : 0 );
        }

        wait( 2.0 );

    }

}
