//  port speed test program
//  this code is based on ..
//    http://mbed.org/users/simon/notebook/busout-portout-digitalout-speedup/

#include "mbed.h"

BusOut bus(P1_24, P1_25, P1_26, P1_27, P1_28, P1_29, P1_30, P1_31);
PortOut port(Port0, 0x00000FF0);
DigitalOut out(LED1);

Timer t;

int main() {
//    printf("    ** port speed test **\r\n");

    t.start();
    for(int i=0; i<1000000; i++) {
        bus = 0;
        bus = 0xFF;
    }
    printf("    BusOut  = %8d kHz\r\n",(int)( 1000.0 / t));

    t.reset();
    for(int i=0; i<1000000; i++) {
        port = 0;
        port = 0xFF000000;
    }
    printf("    PortOut = %8d kHz\r\n", (int)(1000.0 / t));
    
    t.reset();
    for(int i=0; i<1000000; i++) {
        out = 0;
        out = 1;
    }
    printf("    DigitalOut = %8d kHz\r\n", (int)(1000.0 / t));
}

