#include "mbed.h"
#include "PCA9956A.h"

I2C i2c( p28, p27 );//  SDA, SCL

#define     CURRENT_SETTING     1.0

PCA9956A    lc[]    =  {
    PCA9956A( i2c, 0x02 ),
    PCA9956A( i2c, 0x04 )
};

LedPwmOutCC led[ 3 ][ 16 ]  = {
    {
        LedPwmOutCC( lc[ 0 ], L0  ),
        LedPwmOutCC( lc[ 0 ], L3  ),
        LedPwmOutCC( lc[ 0 ], L6  ),
        LedPwmOutCC( lc[ 0 ], L9  ),
        LedPwmOutCC( lc[ 1 ], L0  ),
        LedPwmOutCC( lc[ 1 ], L3  ),
        LedPwmOutCC( lc[ 1 ], L6  ),
        LedPwmOutCC( lc[ 1 ], L9  ),
        LedPwmOutCC( lc[ 1 ], L12 ),
        LedPwmOutCC( lc[ 1 ], L15 ),
        LedPwmOutCC( lc[ 1 ], L18 ),
        LedPwmOutCC( lc[ 1 ], L21 ),
        LedPwmOutCC( lc[ 0 ], L12 ),
        LedPwmOutCC( lc[ 0 ], L15 ),
        LedPwmOutCC( lc[ 0 ], L18 ),
        LedPwmOutCC( lc[ 0 ], L21 ),
    },
    {
        LedPwmOutCC( lc[ 0 ], L1  ),
        LedPwmOutCC( lc[ 0 ], L4  ),
        LedPwmOutCC( lc[ 0 ], L7  ),
        LedPwmOutCC( lc[ 0 ], L10 ),
        LedPwmOutCC( lc[ 1 ], L1  ),
        LedPwmOutCC( lc[ 1 ], L4  ),
        LedPwmOutCC( lc[ 1 ], L7  ),
        LedPwmOutCC( lc[ 1 ], L10 ),
        LedPwmOutCC( lc[ 1 ], L13 ),
        LedPwmOutCC( lc[ 1 ], L16 ),
        LedPwmOutCC( lc[ 1 ], L19 ),
        LedPwmOutCC( lc[ 1 ], L22 ),
        LedPwmOutCC( lc[ 0 ], L13 ),
        LedPwmOutCC( lc[ 0 ], L16 ),
        LedPwmOutCC( lc[ 0 ], L19 ),
        LedPwmOutCC( lc[ 0 ], L22 ),
    },
    {
        LedPwmOutCC( lc[ 0 ], L2  ),
        LedPwmOutCC( lc[ 0 ], L5  ),
        LedPwmOutCC( lc[ 0 ], L8  ),
        LedPwmOutCC( lc[ 0 ], L11 ),
        LedPwmOutCC( lc[ 1 ], L2  ),
        LedPwmOutCC( lc[ 1 ], L5  ),
        LedPwmOutCC( lc[ 1 ], L8  ),
        LedPwmOutCC( lc[ 1 ], L11 ),
        LedPwmOutCC( lc[ 1 ], L14 ),
        LedPwmOutCC( lc[ 1 ], L17 ),
        LedPwmOutCC( lc[ 1 ], L20 ),
        LedPwmOutCC( lc[ 1 ], L23 ),
        LedPwmOutCC( lc[ 0 ], L14 ),
        LedPwmOutCC( lc[ 0 ], L17 ),
        LedPwmOutCC( lc[ 0 ], L20 ),
        LedPwmOutCC( lc[ 0 ], L23 ),
    }
};


void simple_loop( void )
{
    for ( int color = 0; color < 3; color++ ) {
        for ( int i = 0; i < 16; i++ ) {
            led[ color ][ i ].current( CURRENT_SETTING );
        }
    }

    for ( int repeat = 0; repeat < 2; repeat++ ) {
        for ( int color = 0; color < 3; color++ ) {
            for ( int i = 0; i < 16; i++ ) {
                led[ color ][ i ]   = 1.0;
                wait( 0.02 );
            }
        }
        for ( int color = 0; color < 3; color++ ) {
            for ( int i = 0; i < 16; i++ ) {
                led[ color ][ i ]   = 0.0;
                wait( 0.02 );
            }
        }
    }
}

#define     N_OF_REPEATS    4
#define     CYCLE_STEPS     256
#define     PI              3.14159265

void demo_colors_inphase( void )
{
    float   brightness[ 3 ];

    for ( int repeat = 0; repeat < 3; repeat++ ) {
        for ( int i = 0; i < CYCLE_STEPS; i++ ) {
            brightness[ 0 ] = pow( sin( (float)(i +   0) * PI / CYCLE_STEPS ), 4 );
            brightness[ 1 ] = pow( sin( (float)(i +  85) * PI / CYCLE_STEPS ), 4 );
            brightness[ 2 ] = pow( sin( (float)(i + 170) * PI / CYCLE_STEPS ), 4 );

            for ( int color = 0; color < 3; color++ ) {
                for ( int j = 0; j < 16; j++ ) {
                    led[ color ][ j ]   = brightness[ color ];
                }
            }
            wait( 0.01 );
        }
    }
}

void demo_colors_phase_gap( void )
{
    for ( int repeat = 0; repeat < 10; repeat++ ) {
        for ( int i = 0; i < CYCLE_STEPS; i++ ) {
            for ( int j = 0; j < 16; j++ ) {
                led[ 0 ][ j ] = pow( sin( (float)(i +   0 + j * 16) * PI / CYCLE_STEPS ), 4 );
                led[ 1 ][ j ] = pow( sin( (float)(i +  85 + j * 16) * PI / CYCLE_STEPS ), 4 );
                led[ 2 ][ j ] = pow( sin( (float)(i + 170 + j * 16) * PI / CYCLE_STEPS ), 4 );
            }
            //wait( 0.01 );
        }
    }
}

int main()
{
    i2c.frequency( 400 * 1000 );

    while( 1 ) {
        simple_loop();
        demo_colors_inphase();
        simple_loop();
        demo_colors_phase_gap();
    }
}