/**
 *  PCA9547 library "Hello world" sample 
 *
 *  @author  Tedd OKANO
 *  @version 0.2
 *  @date    Feb-2015
 *
 *  PCA9547: an I2C bus multiplexer control library
 *
 *  PCA9547 is an I2C multiplexer which enables to select 1:8 multiplexed I2C bus.
 *  The multiplexer is useful for deviding I2C bus to avoiding slave address conflict and separating capacitive loads.
 *
 *  For more information about PCA9547:
 *    http://www.nxp.com/documents/data_sheet/PCA9547.pdf
 *
 */

#include "mbed.h"
#include "LM75B.h"
#include "PCA9547.h"

PCA9547 mux( p28, p27, 0xE0 );
    
int main()
{
    mux.select( 0 );
    
    LM75B   tmp0( p28, p27 );   //  making instance after a branch of I2C bus (which is connecting the LM75B) enabled

    while( 1 ) {
        printf( "%.3f\r\n", tmp0.read() );
        wait( 1.0 );
    }
}
