//  mbeduino test code (with 4x4x4 LED Cube shield)
//
//      mbeduino              = http://mbed.org/users/okini3939/notebook/mbeduino/  (Japanese)
//      4x4x4 LED Cube shield = http://www.galileo-7.com/?pid=20015630  (Japanese)
//
//  This is just simple code to check the mbeduino and the 4x4x4 LED Cube shield operation
//  It turns-on each indivisual LEDs one by one. 
//  

#include "mbed.h"
#include "mbeduino_shield.h"

#define     CUBE_SIZE       4                       //  n of nodes on one edge
#define     SR_BIT_LENGTH   (CUBE_SIZE * CUBE_SIZE) //  n of bits on one layer

typedef     unsigned short  U16;    //  bit length should be same or more than SR_BIT_LENGTH

#define     SR_DATA_OUT     ARD_D2  //  data line to the shiftregister
#define     SR_CLCK_OUT     ARD_D3  //  clock line to the shiftregister
#define     CATHODE0        ARD_D11 //  cathode control line for bottom layer
#define     CATHODE1        ARD_D10 //  cathode control line for 2nd layer from bottom
#define     CATHODE2        ARD_D9  //  cathode control line for 3nd layer from bottom
#define     CATHODE3        ARD_D8  //  cathode control line for top layer

DigitalOut  sr_data(SR_DATA_OUT);
DigitalOut  sr_clk(SR_CLCK_OUT);
BusOut      cathode( CATHODE0, CATHODE1, CATHODE2, CATHODE3 );

//U16         main_buffer[ CUBE_SIZE ]    = { 0, 0, 0, 0 };

void set_serialregister( U16 v );

int main() {
    cathode = 0x0;

    while (1) {
        for ( int c = 0; c < CUBE_SIZE; c++ ) {
            for ( int i = 0; i < SR_BIT_LENGTH; i++ ) {
                set_serialregister( 0x0001 << i );
                
                cathode = 0x1 << c;
                wait( 0.05 );
                cathode = 0x0;
            }
        }
    }
}

void set_serialregister( U16 v ) {
    for ( int i = 0; i < SR_BIT_LENGTH; i++ ) {
        sr_data = ((v >> i) & 0x1);
        sr_clk  = 0;
        sr_clk  = 1;
    }
}


















