/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

/* mbed-fest hands-on session sample 2
 * bare-metal blinky with classic style code
 */

#include "mbed.h"
#include "FXOS8700Q.h"
I2C                     i2c( PTE25, PTE24 );
FXOS8700QAccelerometer  acc( i2c, FXOS8700CQ_SLAVE_ADDR1 );

DigitalOut led_x( LED1 );
DigitalOut led_y( LED2 );
DigitalOut led_z( LED3 );

int main(void)
{
    float   x, y, z;

    // 加速度センサーの初期化
    acc.enable();

    while (true) {

        // データの取得
        acc.getX( x );
        acc.getY( y );
        acc.getZ( z );

        // LED点滅
        if ( x > 0 )
            led_x = 1;
        else
            led_x = 0;

        if ( y > 0 )
            led_y = 1;
        else
            led_y = 0;

        if ( z > 0 )
            led_z = 1;
        else
            led_z = 0;

        // データの出力(コンソールへ)
        printf("X:%6.1f, Y:%6.1f, Z:%6.1f\r\n", x * 90.0, y * 90.0, z * 90.0 );
        wait( 0.5 );
    }
}