#include "mbed.h"
#include "SDFileSystem.h"

//DigitalOut led[]    = { LED4, LED3, LED2, LED1 };
BusOut          led( LED4, LED3, LED2, LED1 );
SDFileSystem    sd(p5, p6, p7, p8, "sd");
LocalFileSystem local("local");
Serial          pc(USBTX, USBRX); // tx, rx

//#define        SOURCE_FILE        "/local/source.jpg"
//#define        TARGET_FILE        "/sd/target.jpg"

#define        SOURCE_FILE        "/sd/temp_log.txt"
#define        TARGET_FILE        "/local/temp_log.txt"

#define        COPY_BLOCK_SIZE    2048

int main() {

    FILE    *fs_src;
    FILE    *fs_tgt;
    char    s[ COPY_BLOCK_SIZE ];
    int     size;
    int     total    = 0;
    int     progress_ind    = 0;
    
    pc.printf( "\nfile copier started.\n" );
    pc.printf( "  source:%s >>> target:%s\n", SOURCE_FILE, TARGET_FILE );

    if ( NULL == (fs_src    = fopen( SOURCE_FILE, "rb" )) )
    {
        error( "couldn't open source file" );
        return ( 1 );
    }   
    if ( NULL == (fs_tgt    = fopen( TARGET_FILE, "wb" )) )
    {
        error( "couldn't open target file" );
        return ( 2 );
    }   

    while (  size    = fread( s, sizeof( char ), COPY_BLOCK_SIZE, fs_src ) )
    {
        fwrite( s, sizeof( char ), size, fs_tgt );
        total    += size;

        led    = (0x1 << progress_ind++ % 4);

        pc.printf( "  %d bytes copied\r", total );
    }
    
    led    = 0xF;
    
    fclose( fs_src );
    fclose( fs_tgt );
    
    pc.printf( "\ndone\n" );

}
