#include "mbed.h"                   //  for mbed
LocalFileSystem     local("local"); //  for mbed to access local file system

/*
 *
 *   BMP file data handler sample
 *
 *      reference : http://www.umekkii.jp/data/computer/file_format/bitmap.cgi
 *
 */

#include    <stdio.h>

//#define        SOURCE_FILE            "/local/small.bmp"
#define        SOURCE_FILE            "/local/pre4.bmp"
//#define        SOURCE_FILE            "pre_dsp_4.bmp"

#define        BUFFER_SIZE            1024

typedef struct  bmp_header_st    {
    unsigned short  bfType            __attribute__((packed));
    unsigned long   bfSize            __attribute__((packed));
    unsigned short  bfReserved1       __attribute__((packed));
    unsigned short  bfReserved2       __attribute__((packed));
    unsigned long   bfOffBits         __attribute__((packed));

    unsigned long   biSize            __attribute__((packed));
    long            biWidth           __attribute__((packed));
    long            biHeight          __attribute__((packed));
    unsigned short  biPlanes          __attribute__((packed));
    unsigned short  biBitCount        __attribute__((packed));
    unsigned long   biCompression     __attribute__((packed));
    unsigned long   biSizeImage       __attribute__((packed));
    long            biXPixPerMeter    __attribute__((packed));
    long            biYPixPerMeter    __attribute__((packed));
    unsigned long   biClrUsed         __attribute__((packed));
    unsigned long   biCirImportant    __attribute__((packed));
}
bmp_header;

typedef struct  color_palette_st    {
    unsigned char    red;
    unsigned char    green;
    unsigned char    blue;
    unsigned char    dummy;
}
color_palette;


int main() {
    unsigned char    buffer[ BUFFER_SIZE ];
    FILE             *fs;
    bmp_header       bh;
    color_palette    cp[256];
    unsigned long    readsize;
    unsigned long    i;
    unsigned long    ofset    = 0;

    printf( "BMP file access sample\r\n");

    if ( NULL == (fs    = fopen( SOURCE_FILE, "rb" )) ) {
        printf( "file open error when oening file \"%s\"\r\n", SOURCE_FILE );
        return ( 1 );
    }

    /*
     *   reading header
     */

    fread( &bh, sizeof( bh ), 1, fs );

    printf( "  bfType         : 0x%04X\r\n", bh.bfType );
    printf( "  bfSize         : %ld\r\n",    bh.bfSize );
    printf( "  bfOffBits      : %ld\r\n",    bh.bfOffBits );
    printf( "  biSize         : %lu\r\n",    bh.biSize );
    printf( "  biWidth        : %ld\r\n",    bh.biWidth );
    printf( "  biHeight       : %ld\r\n",    bh.biHeight );
    printf( "  biPlanes       : %d\r\n",     bh.biPlanes );
    printf( "  biBitCount     : %d\r\n",     bh.biBitCount );
    printf( "  biCompression  : %lu\r\n",    bh.biCompression );
    printf( "  biSizeImage    : %lu\r\n",    bh.biSizeImage );
    printf( "  biXPixPerMeter : %ld\r\n",    bh.biXPixPerMeter );
    printf( "  biYPixPerMeter : %ld\r\n",    bh.biYPixPerMeter );
    printf( "  biClrUsed      : %lu\r\n",    bh.biClrUsed );
    printf( "  biCirImportant : %lu\r\n",    bh.biCirImportant );

    /*
     *   checking header
     */

    if ( (bh.bfType != 0x4D42)
            || (bh.bfOffBits != 54 + 256 * sizeof( color_palette ) )
            || (bh.biBitCount != 8)
            || (bh.biCompression != 0)
       ) {
        printf( "unsupported file format\r\n" );
        return ( 1 );
    }

    /*
     *   header information
     */

    printf( "header read, the image data size is %lu bytes\r\n", bh.bfSize );
    printf( "   the image data size is %lu bytes\r\n", bh.biSizeImage );
    printf( "   horizontal size %lu pixels\r\n", bh.biWidth );
    printf( "   vertical   size %lu pixels\r\n", bh.biHeight );

    /*
     *   read color palette
     */

    for ( i = 0; i < 256; i++ ) {
        fread( &(cp[i]), sizeof( color_palette ), 1, fs );
//        printf( "cp 0x%02X : 0x%02X - 0x%02X - 0x%02X\r\n", i, (cp[i]).red, (cp[i]).green, (cp[i]).blue );
    }


    while ( 0 != (readsize    = fread( buffer, sizeof( unsigned char ) , BUFFER_SIZE, fs )) ) {
        for ( i = 0; i < readsize; i++ ) {
//            printf( "  %6lX : 0x%02X, 0x%02X, 0x%02X\r\n", ofset, cp[ buffer[i] ].red, cp[ buffer[i] ].green, cp[ buffer[i] ].blue );
            ofset++;
        }
    }

    printf( "done.\r\n\r\n" );
}
