/*
 *  mbed + LPCXpresso_baseboard demo code
 *
 *   This code has been made for a training session. 
 *
 *   With this code, the mbed drives PCA9532 to control 16 LEDs. 
 *   The LED blinked in pattern. 
 *
 *   On this demo, the ISL29003 is also driven to get ambient 
 *   light level. The ambient light get dark, the LED blightness 
 *   get low. The LEDs are controlled by PWM function of PCA9532. 
 *
 *  Copyright (c) 2010 NXP Semiconductors Japan
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  revision 1.0  16-Feb-2010   1st release
 */

#include "mbed.h"

I2C     i2c( p28, p27 );
Serial  pc( USBTX, USBRX );

const int   PCA9532_addr  = 0xC0;
const int   ISL29003_addr = 0x88;

class baseboard_led_array {
public:

    baseboard_led_array() {
    }

    ~baseboard_led_array() {
    }

    void operator=( int c ) {

        char        a[ 5 ]  = { 0x16, 0x00, 0x00, 0x00, 0x00 };
        const char  v       = 0x2;

        for ( int i = 0; i < 16; i++ )
            a[ (i / 4) + 1 ]  |= (((c >> i) & 0x1) ? v : 0x0) << ((i % 4) << 1);

        i2c.write( PCA9532_addr, a, 5 );
    }

    void pwm0( char c ) {
        char    cmd[ 2 ];

        cmd[ 0 ]    = 0x03;
        cmd[ 1 ]    = c;
        i2c.write( PCA9532_addr, cmd, 2 );
    }
};


class light_sensor {
public:

    light_sensor() {
        char    cmd[ 2 ];

        cmd[ 0 ]    = 0x00;
        cmd[ 1 ]    = 0x80;
        i2c.write( ISL29003_addr, cmd, 2 );

        cmd[ 0 ]    = 0x01;
        cmd[ 1 ]    = 0x00;
        i2c.write( ISL29003_addr, cmd, 2 );
    }

    ~light_sensor() {
    }

    operator short( void ) {

        short   v;
        char    cmd;

        cmd    = 0x04;
        i2c.write( ISL29003_addr, &cmd, 1 );
        i2c.read( ISL29003_addr, &cmd, 1 );
        v   = cmd;

        cmd    = 0x05;
        i2c.write( ISL29003_addr, &cmd, 1 );
        i2c.read( ISL29003_addr, &cmd, 1 );

        return( (((short)cmd) << 8) | v );
    }
};

baseboard_led_array     ledarr;
light_sensor            sensor;

int main() {

    unsigned long   c   = 0x00000F0F;
    short           b;

    while ( 1 ) {
    
        b   = sensor >> 6;
        ledarr.pwm0( b > 255 ? 255 : (char)b );
        
        c   <<= 1;
        c   |= c & 0x10000 ? 0x1 : 0x0;
        ledarr   = c;

        wait( 0.05 );
    }
}

