/*
 *  "Hello code" for SC18IS606 library
 *
 *  @author     Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version    0.2
 *  @date       28-July-2021
 *
 *  SC18IS606 is an "I2C-bus to SPI bridge"
 *  http://www.nxp.com/ (product infomation page will be updated later)
 */

#include "mbed.h"
#include "SC18IS606.h"

I2C         i2c( p28, p27 );
InterruptIn int_line( p21 );
SC18IS606   bridge( i2c );      //  make a SC18IS606 instance as "bridge"

#define I2C_FREQUENCY       (400 * 1000)    // Hz
#define SLAVE_SELECT_NUM    0
#define DATA_LENGTH         256

void    data_check( char *data, int length );

volatile int    int_flag    = false;

void int_handler()
{
    int_flag    = true;
}

void wait_transfer_done( void )
{
    while ( !int_flag )
        ;

    bridge.clear_interrupt();
    int_flag    = false;
}

void hardware_settings( void )
{
    int_line.mode( PullUp );
    int_line.fall( &int_handler );
    i2c.frequency( I2C_FREQUENCY );
}

int main()
{
    printf( "SC18IS606 Hello\r\n" );

    hardware_settings();
    bridge.install_wait_func( wait_transfer_done );

    printf( "%s\r\n", bridge.read_version() );
    
    char    snd_data[ DATA_LENGTH ];
    char    rcv_data[ DATA_LENGTH ]; 

    for ( int i = 0; i < DATA_LENGTH; i++ ) {
        snd_data[ i ]  = i;
    }

    while(1) {
        bridge.transfer( SLAVE_SELECT_NUM, snd_data, sizeof( snd_data ) );
        bridge.read_buffer( rcv_data, sizeof( rcv_data ) );
        data_check( rcv_data, DATA_LENGTH );
    }
}

void data_check( char *data, int length )
{
    for ( int i = 0; i < length; i++ ) {
        if ( !(i % 16) )
            printf( "\r\n %02X :", i );
        printf( " %02X", data[ i ] );
    }
}
