#include "mbed.h"

Serial  pc( p9, p10 );

char    data[]  = { 'W', 0x02, 0xAA, 0x03, 0xAA, 'P' };
char    gpio0[] = { 'O', 0x55, 'P' };
char    gpio1[] = { 'O', 0xAA, 'P' };

void put_binary( char *b, int size )
{
    for ( int i = 0; i < size; i++ ) {
        pc.putc( *b++ );
    }
}

int main()
{
    int i   = 0;

    pc.baud( 9600 );
    put_binary( data, sizeof( data ) );

    while(1) {
        put_binary( gpio0, sizeof( gpio0 ) );
        wait( 0.1 );
        put_binary( gpio1, sizeof( gpio1 ) );
        wait( 0.1 );
    }
}
