#include    "mbed.h"
#include    "SC16IS750.h"

#define XTAL_FREQUENCY              14784000    //  Hz
#define REGISTER_ACCESS_SIZE        2

#define REGISTER_INIT_BY_RESTART    true

char    init[][ REGISTER_ACCESS_SIZE ] = {
    { SC16IS750::LCR, 0x80 },
    { SC16IS750::DLL, 0x60 },
    { SC16IS750::DLH, 0x00 },
    { SC16IS750::LCR, 0xBF },
    { SC16IS750::EFR, 0x10 },
    { SC16IS750::LCR, 0x03 },
    { SC16IS750::IER, 0x00 },
    { SC16IS750::FCR, 0x07 },
};


SC16IS750::SC16IS750(
    PinName I2C_sda,
    PinName I2C_scl,
    int     baud_rate,
    char    I2C_address
) : i2c( I2C_sda, I2C_scl ), i2c_addr( I2C_address ) {

    int     baud_setting;

    i2c.frequency( 400 * 1000 );

    baud_setting    = XTAL_FREQUENCY / (baud_rate * 16);
    init[ 1 ][ 1 ]  = (char)baud_setting;
    init[ 2 ][ 1 ]  = (char)(baud_setting >> 8);

    init_registers();
    
    i2c.stop();
}

void SC16IS750::set_baud( int baud ) {
    int     baud_setting;

    baud_rate   = baud;
    baud_setting    = XTAL_FREQUENCY / (baud_rate * 16);

    register_write( SC16IS750::LCR, 0x80 );
    register_write( SC16IS750::DLL, (char)baud_setting );
    register_write( SC16IS750::DLH, (char)(baud_setting >> 8) );
    register_write( SC16IS750::LCR, 0x03 );
}

void SC16IS750::init_registers( void ) {
    for ( int i = 0; i <  (sizeof( init ) / REGISTER_ACCESS_SIZE); i++ )
        i2c.write( i2c_addr, init[ i ], REGISTER_ACCESS_SIZE, REGISTER_INIT_BY_RESTART );
}

void SC16IS750::send_str( const char *s ) {
    char    buffer[ 65 ];
    int     i   = 1;

    buffer[ 0 ] = 0x00; //  register address

#if 0
    while ( buffer[ i++ ]   = *s++ )
        ;
#else
    for ( i = 1; i < 65; i++ )
        if ( !(buffer[ i ]   = *s++) )
            break;
#endif

    i2c.write( i2c_addr, buffer, i );
}


void SC16IS750::register_write( char register_address, char data ) {
    char    w[ 2 ];

    w[ 0 ]  = register_address;
    w[ 1 ]  = data;

    i2c.write( i2c_addr, w, 2 );
}

char SC16IS750::register_read( char register_address ) {
    char    r;

    i2c.write( i2c_addr, &register_address, 1 );
    i2c.read( i2c_addr, &r, 1 );

    return ( r );
}
