#ifndef MBED_SC16IS750
#define MBED_SC16IS750


#define DEFAULT_SC16IS750_ADDR  0x9A
#define DEFAULT_BAUD_RATE       9600

class SC16IS750 {
public:

    typedef enum {
        RHR         = 0x00 << 3,
        THR         = 0x00 << 3,
        IER         = 0x01 << 3,
        FCR         = 0x02 << 3,
        IIR         = 0x02 << 3,
        LCR         = 0x03 << 3,
        MCR         = 0x04 << 3,
        LSR         = 0x05 << 3,
        MSR         = 0x06 << 3,
        SPR         = 0x07 << 3,
        TCR         = 0x06 << 3,
        TLR         = 0x07 << 3,
        TXLVL       = 0x08 << 3,
        RXLVL       = 0x09 << 3,
        IODir       = 0x0A << 3,
        IOState     = 0x0B << 3,
        IOIntEna    = 0x0C << 3,
        reserved    = 0x0D << 3,
        IOControl   = 0x0E << 3,
        EFCR        = 0x0F << 3,
        DLL         = 0x00 << 3,
        DLH         = 0x01 << 3,
        EFR         = 0x02 << 3,
        XON1        = 0x04 << 3,
        XON2        = 0x05 << 3,
        XOFF1       = 0x06 << 3,
        XOFF2       = 0x07 << 3,
    } RegisterName;

    SC16IS750(
        PinName I2C_sda,
        PinName I2C_scl,
        int     baud_rate   = DEFAULT_BAUD_RATE,
        char    I2C_address = DEFAULT_SC16IS750_ADDR
    );

    void init_registers( void );
    void set_baud( int );
    void send_str( const char *s );
    void register_write( char register_address, char data );
    char register_read( char register_address );

private:
    I2C     i2c;
    int     baud_rate;
    char    i2c_addr;
};

#endif  //  MBED_SC16IS750
