/** PCT2075 and LM75B component class library
 *  PCT2075 と LM75B 用のコンポーネント・クラス・ライブラリです
 *
 *  This is new NXP PCT2075 and classic LM75B component class library
 *  This works for both PCT2075 and LM75B
 *
 *  @author  Tedd OKANO
 *  @version 1.0
 *  @date    05-Mar-2015
 *
 *  Released under the Apache 2 license License
 *
 *  For the details of PCT2075 and LM75B..
 *  PCT2075 and LM75Bの詳細は..
 *      http://www.nxp.com/documents/data_sheet/PCT2075.pdf
 *      http://www.nxp.com/documents/data_sheet/LM75B.pdf
 */

#ifndef MBED_I2CTempSensor_H
#define MBED_I2CTempSensor_H

#include "mbed.h"

/** I2CTempSensor class library クラスライブラリ
 *
 *  This class is an abstract class. So no instance can be made.
 *  このクラスは抽象クラスなのでインスタンスを作成することはできません
 *  クラスライブラリは非常にシンプルなインターフェースを提供します
 */

class I2CTempSensor
{
public:
    virtual float   read( void )    = 0;
    virtual operator float( void )  = 0;

protected:

    /** LM75Bのレジスタ名とアドレス */
    enum command_reg    {
        LM75B_Temp  = 0x00,
        LM75B_Conf,
        LM75B_Thyst,
        LM75B_Tos
    };

    /** I2Cピンとスレーブアドレスを指定し，インスタンスを作成します
     *
     * @param i2c_sda I2C-bus i2c_sdaピン
     * @param i2c_scl I2C-bus i2c_sclピン
     * @param address (オプション) I2C-bus スレーブアドレス (デフォルト: 0x90)
     */
    I2CTempSensor( PinName i2c_sda, PinName i2c_scl, char address );

    /** I2Cオブジェクトとスレーブアドレスを指定し，インスタンスを作成します
     *
     * @param i2c_obj I2C オブジェクト (インスタンス)
     * @param address (オプション) I2C-bus スレーブアドレス (デフォルト: 0x90)
     */
    I2CTempSensor( I2C &i2c_obj, char address );

    /** デストラクタ
     */
    ~I2CTempSensor();

    /** 初期化
     */
    void    init( void );

    /** 温度の読み出し
     *
     *  @return 摂氏温度を返します(float型)
     */
    short   read16( void );

private:
    I2C     *i2c_p;
    I2C     &i2c;
    char    adr;
};

#endif  //  MBED_I2CTempSensor_H

