#include    "I2CTempSensor.h"
#include    "PCT2075.h"

PCT2075::PCT2075( PinName i2c_sda, PinName i2c_scl, char i2c_address ) 
    : I2CTempSensor( i2c_sda, i2c_scl, i2c_address )
{
    init();
}

PCT2075::PCT2075( I2C &i2c_obj, char i2c_address )
    : I2CTempSensor( i2c_obj, i2c_address )
{
    init();
}

PCT2075::~PCT2075()
{
}

float PCT2075::read( void )
{
    typedef I2CTempSensor base;

    return( base::read16() / 256.0 );
}

PCT2075::operator float( void )
{
    return( read() );
}
