#include "I2CTempSensor.h"

I2CTempSensor::I2CTempSensor( PinName i2c_sda, PinName i2c_scl, char address ) 
    : i2c_p( new I2C( i2c_sda, i2c_scl ) ), i2c( *i2c_p ), adr( address )
{
    init();
}

I2CTempSensor::I2CTempSensor( I2C &i2c_obj, char address )
    : i2c_p( NULL ), i2c( i2c_obj ), adr( address )
{
    init();
}

I2CTempSensor::~I2CTempSensor()
{
    if ( NULL != i2c_p )
        delete  i2c_p;
}

void I2CTempSensor::init( void )
{
    char    command[ 2 ];

    command[ 0 ]    = LM75B_Conf;
    command[ 1 ]    = 0x00;

    i2c.write( adr, command, 2 );
}

short I2CTempSensor::read16( void )
{
    char    command[ 2 ];

    command[ 0 ]    = LM75B_Temp;

    i2c.write( adr, command, 1 );  // Send command string
    i2c.read(  adr, command, 2 );  // read two bytes data

    return ( (command[ 0 ] << 8)| command[1] );
}
