/** PCT2075 and LM75B component class library
 *  PCT2075 と LM75B 用のコンポーネント・クラス・ライブラリです
 *
 *  This is new NXP PCT2075 and classic LM75B component class library
 *  This works for both PCT2075 and LM75B
 *
 *  @author  Tedd OKANO
 *  @version 1.0
 *  @date    05-Mar-2015
 *
 *  For the details of PCT2075 and LM75B..
 *  PCT2075 and LM75Bの詳細は..
 *      http://i2c_sda.nxp.com/documents/data_sheet/PCT2075.pdf
 *      http://i2c_sda.nxp.com/documents/data_sheet/LM75B.pdf
 */

#ifndef MBED_PCT2075_H
#define MBED_PCT2075_H

#include    "mbed.h"
#include    "I2CTempSensor.h"

/** PCT2075 & LM75B class library / PCT2075 & LM75B クラスライブラリ
 *
 *  Class library provides very simple interface to read sensor value
 *  クラスライブラリはセンサの値を読む非常にシンプルなインターフェースを提供します
 *
 *  Example / コード例:
 *  @code
 *  #include "mbed.h"
 *  #include "PCT2075.h"                //  or #include "LM75B.h"
 *  
 *  PCT2075 temp_sensor( p28, p27 );    //  or LM75B temp_sensor( p28, p27 );
 *  
 *  int main()
 *  {
 *      while(1) {
 *          printf( "temp = %7.3f\r\n", (float)temp_sensor );
 *          wait( 1 );
 *      }
 *  }
 *  @endcode
 */
class PCT2075 : I2CTempSensor
{
public:
    /** Create a PCT2075 instance connected to specified I2C pins with specified address
     *  I2Cピンとスレーブアドレスを指定し，インスタンスを作成します
     *
     * @param i2c_sda       I2C-bus SDA pin
     * @param i2c_scl       I2C-bus SCL pin
     * @param i2c_address   (option) I2C-bus slave address (default: 0x90)
     */
    PCT2075( PinName i2c_sda, PinName i2c_scl, char i2c_address = DEFAULT_I2C_SLAVE_ADDRESS );

    /** Create a PCT2075 instance with I2C instance and specified address
     *  I2Cオブジェクトとスレーブアドレスを指定し，インスタンスを作成します
     *
     * @param i2c_obj       I2C object (instance)
     * @param i2c_address   (option) I2C-bus slave address (default: 0x90)
     */
    PCT2075( I2C &i2c_obj, char i2c_address = DEFAULT_I2C_SLAVE_ADDRESS );

    /** デストラクタ
     */
    virtual ~PCT2075();

    /** Read temperature / 温度の読み出し
     *
     *  @return Returns temperature in Celsius (float) / 摂氏温度を返します(float型)
     */
    virtual float   read( void );

    /**  Read temperature / 温度の読み出し
     *
     *  @return To make the object returns the value / オブジェクトが読みだした値を返すようにしています
     */
    virtual operator float( void );

private:
    /** デフォルト・スレーブアドレス */
    enum {
        DEFAULT_I2C_SLAVE_ADDRESS   = 0x90
    };
};

#endif  //  MBED_PCT2075_H

