#include "mbed.h"
#include "PCA9955A_registers.h"

I2C i2c( p28, p27 );    //  SDA, SCL

#define     SLAVE_ADDR              0x02    //  I2C target (slave) adress

void register_write( char addr, char data );

int main()
{
    //  initialization

    register_write( MODE1,      0x00 ); //  mode setting
    register_write( MODE2,      0x25 ); //  mode setting
    register_write( LEDOUT0,    0xAA ); //  PWM output setting for LED0  .. LED3 
    register_write( LEDOUT1,    0xAA ); //  PWM output setting for LED4  .. LED7
    register_write( LEDOUT2,    0xAA ); //  PWM output setting for LED8  .. LED11
    register_write( LEDOUT3,    0xAA ); //  PWM output setting for LED12 .. LED15
    register_write( IREFALL,    0x10 ); //  set all IREF register (output current setting)

    //  operation loop

    while ( 1 ) {
        
        //  LED0 luminanceset from 0 to max by PWM
        for ( int i = 0; i < 256; i++ ) {
            register_write( PWM0, i );
            wait( 0.01 );
        }

        //  LED0 luminanceset from max to 0 by PWM
        for ( int i = 255; i >= 0; i-- ) {
            register_write( PWM0, i );
            wait( 0.01 );
        }
    }
}

void register_write( char addr /* register address */, char data /* data value */ )
{
    char    d[ 2 ];

    d[ 0 ]   = addr;
    d[ 1 ]   = data;
    i2c.write( SLAVE_ADDR, d, 2 );  //  two bytes transfer to I2C target device which has address of SLAVE_ADDR
}

