/** PCA9955A constant current LED driver control library
 *
 *  @class   PCA9955A
 *  @author  NXP Semiconductors Japan
 *  @version 0.5(15-Jun-2011) (publish 10-Aug-2012)
 *
 *  Copyright: 2011 NXP Semiconductors
 *  Released under the MIT License: http://mbed.org/license/mit
 *  This is a library that controls PCA9955A a constant current LED driver
 *  Example:
 *  @code
 *  #include    "mbed.h"
 *  #include    "PCA9955A.h"
 *
 *  #define     MAX_IREF    0x20
 *
 *  PCA9955A     led_driver( p28, p27, 0xC0 );  // making an instance of PCA9955A
 *
 *  main()
 *  {
 *      char    v[ 16 ] = { 0xFF };
 *      int     sel;
 *
 *      srand( 0 );
 *
 *      led_driver  = 0xFFFF;
 *      led_driver.set_all_intensity( v );              //  PWM
 *      led_driver.set_all_intensity( MAX_IREF, true ); //  IREF
 *
 *      while ( 1 ) {
 *          for ( sel = 0; sel < 16; sel++ ) {
 *              v[ sel ]  = (char)((float)(v[ sel ]) * 0.8);
 *          }
 *
 *          v[ rand() % 16 ]  = 0xFF;
 *
 *          led_driver.set_all_intensity( v );              //  PWM
 *          wait( 0.05 );
 *      }
 *  }
 *  @endcode
 */

#ifndef     MBED_PCA9955A
#define     MBED_PCA9955A

#include    "mbed.h"

//  PCA9955A I2C address

#if 0
#define     PCA9955A_ADDR            0xC0

#define     PCA9955A_INIT_PWM        0xFF
#define     PCA9955A_N_OF_PORTS      16

#define     AUTO_INCREMENT           0x80
#define     REGISTER_START           0x00
#define     LEDOUT_REGISTER_START    0x02
#define     PWM_REGISTER_START       0x0A
#define     IREF_REGISTER_START      0x22
#endif

class PCA9955A
{
public:
    enum command_reg {
        MODE1   = 0x00,
        MODE2,
        LEDOUT0,
        LEDOUT1,
        LEDOUT2,
        LEDOUT3,
        GRPPWM  = 0x06,
        GRPFREQ,
        PWM0    = 0x08,
        PWM1,
        PWM2,
        PWM3,
        PWM4,
        PWM5,
        PWM6,
        PWM7,
        PWM8,
        PWM9,
        PWM10,
        PWM11,
        PWM12,
        PWM13,
        PWM14,
        PWM15,
        IREF0   = 0x18,
        IREF1,
        IREF2,
        IREF3,
        IREF4,
        IREF5,
        IREF6,
        IREF7,
        IREF8,
        IREF9,
        IREF10,
        IREF11,
        IREF12,
        IREF13,
        IREF14,
        IREF15,
        RAMP_RATE_GRP0  = 0x28,
        STEP_TIME_GRP0,
        HOLD_CNTL_GRP0,
        IREF_GRP0,
        RAMP_RATE_GRP1,
        STEP_TIME_GRP1,
        HOLD_CNTL_GRP1,
        IREF_GRP1,
        RAMP_RATE_GRP2,
        STEP_TIME_GRP2,
        HOLD_CNTL_GRP2,
        IREF_GRP2,
        RAMP_RATE_GRP3,
        STEP_TIME_GRP3,
        HOLD_CNTL_GRP3,
        IREF_GRP3,
        GRAD_MODE_SEL0  = 0x38,
        GRAD_MODE_SEL1,
        GRAD_GRP_SEL0,
        GRAD_GRP_SEL1,
        GRAD_GRP_SEL2,
        GRAD_GRP_SEL3,
        GRAD_CNTL,
        OFFSET  = 0x3F,
        SUBADR1,
        SUBADR2,
        SUBADR3,
        ALLCALLADR,
        PWMALL,
        IREFALL,
        EFLAG0,
        EFLAG1,

        REGISTER_START          = MODE1,
        LEDOUT_REGISTER_START   = LEDOUT0,
        PWM_REGISTER_START      = PWM0,
        IREF_REGISTER_START     = IREF0,
    };

#define     GRAD_GROUP_OFFSET   (RAMP_RATE_GRP1 - RAMP_RATE_GRP0)
#define     CONTINUOUS          1


#define     N_OF_PORTS      16
    PCA9955A( PinName I2C_sda, PinName I2C_scl, char I2C_address );
    void set_single_individual_intensity( char port, char val, int iref = false );
    void set_all_intensity( char *p, int iref = false );
    void set_all_intensity( char val, int iref = false );
    void get_all_intensity( char *p, int iref = false );
    void operator=( int c );
    unsigned short fault_test( void );
    void        write( char *data, int length );
    void        write( char reg_addr, char data );
    void        read( char reg_addr, char *data, int length );
    char        read( char reg_addr );


    void gradation_setting( int group, char ramp_rate, char step_time, char hold_cntl, char iref );
    void gradation_start( char group, char continuous_flag );
    void gradation_stop( void );
    void group_selector( short g0, short g1, short g2, short g3 );

private:

    enum {
        PCA9955A_ADDR            = 0xC0,
    };

    enum {
        PCA9955A_INIT_PWM        = 0xFF,
        PCA9955A_N_OF_PORTS      = 16,
    };
    enum {
        AUTO_INCREMENT          = 0x80,
    };


    I2C         i2c;
    char        i2c_addr;
    static char init_array[];
}
;

#endif  //  MBED_PCA9955A
